/**
 * Simple navigation for case study grading - redirects on user change
 *
 * @module     mod_casestudy/grading_navigation_simple
 * @copyright  2025 SCCA
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("mod_casestudy/grading_navigation_simple",["jquery","core/notification","core/str","core/form-autocomplete","core/ajax"],(function($,notification,str,autocomplete,ajax){return{init:function(selector,currentSubmissionId,cmid,casestudyid){var region=$(selector),submissions=[];function navigateToSubmission(submissionId){var url=new URL(window.location.href);url.searchParams.set("submissionid",submissionId),window.location.href=url.toString()}ajax.call([{methodname:"mod_casestudy_get_submissions_for_grading",args:{casestudyid:casestudyid,cmid:cmid},done:function(data){submissions=data,function(data,selectedId){var select=region.find("[data-action=change-user]");select.empty(),data.forEach((function(submission){var option=$("<option></option>").attr("value",submission.id).text(submission.fullname+" - Attempt "+submission.attempt);submission.id===selectedId&&option.attr("selected","selected"),select.append(option)})),select.val(selectedId),str.get_string("changeuser","mod_casestudy").done((function(s){autocomplete.enhance("[data-action=change-user]",!1,"",s),select.val(selectedId).trigger("change.select2")})).fail(notification.exception)}(data,currentSubmissionId),function(){for(var select=region.find("[data-action=change-user]"),currentId=parseInt(select.val(),10),currentIndex=-1,i=0;i<submissions.length;i++)if(submissions[i].id===currentId){currentIndex=i;break}var prevBtn=region.find('[data-action="previous-user"]'),nextBtn=region.find('[data-action="next-user"]');currentIndex<=0?prevBtn.attr("disabled","disabled"):prevBtn.removeAttr("disabled");currentIndex>=submissions.length-1?nextBtn.attr("disabled","disabled"):nextBtn.removeAttr("disabled");current=currentIndex+1,total=submissions.length,str.get_string("xofy","mod_casestudy",{x:current,y:total}).done((function(s){region.find('[data-region="user-count-summary"]').text(s)})).fail(notification.exception);var current,total}()},fail:notification.exception}]),region.find('[data-action="change-user"]').on("change",(function(){var newSubmissionId=parseInt($(this).val(),10);newSubmissionId&&newSubmissionId!==currentSubmissionId&&navigateToSubmission(newSubmissionId)})),region.find('[data-action="previous-user"]').on("click",(function(e){if(e.preventDefault(),!$(this).attr("disabled"))for(var select=region.find("[data-action=change-user]"),currentId=parseInt(select.val(),10),i=0;i<submissions.length;i++)if(submissions[i].id===currentId&&i>0){navigateToSubmission(submissions[i-1].id);break}})),region.find('[data-action="next-user"]').on("click",(function(e){if(e.preventDefault(),!$(this).attr("disabled"))for(var select=region.find("[data-action=change-user]"),currentId=parseInt(select.val(),10),i=0;i<submissions.length;i++)if(submissions[i].id===currentId&&i<submissions.length-1){navigateToSubmission(submissions[i+1].id);break}}))}}}));

//# sourceMappingURL=grading_navigation_simple.min.js.map