<?php

namespace local_nctvideocodec;

use moodle_exception;
use stored_file;

class observer {

    public static function assignment_uploaded($event) {
        global $CFG;

        if (!get_config('local_nctvideocodec', 'enablecompression')) {
            return true;
        }

        // Detect the operating system
        $os = PHP_OS_FAMILY;
        if ($os === 'Linux') {
            $handbrakeclicheck = exec('which HandBrakeCLI 2>&1', $output1, $return);
            $handbrakeclicheck = exec('HandBrakeCLI --version 2>&1', $output2, $return);
            if (!$handbrakeclicheck) {
                return true;
            }
        }

        $nodecheck = strtolower($os) == 'windows' ? exec('where node 2>&1', $output3, $return) : exec('which node 2>&1', $output3, $return);
        if (!$nodecheck) {
            return true;
        }

        $dir = $CFG->dirroot;
        $handbrakejscheck = exec("cd $dir && npm list handbrake-js 2>&1", $output4, $return);
        if (!empty($return)) {
            return true;
        }

        $hases = $event->other['pathnamehashes'] ?? [];

        $fs = get_file_storage();

        foreach ($hases as $hash) {
            $file = $fs->get_file_by_hash($hash);
            if (file_mimetype_in_typegroup($file->get_mimetype(), ['video', 'web_video']) || str_starts_with($file->get_mimetype(), 'video/')) {
                $compressed = self::compress_file($file);
                $compressedfile = self::create_user_draft($compressed, $file);
                $file->replace_file_with($compressedfile);
            }
        }

    }


    protected static function compress_file(stored_file $file) {
        global $CFG;

        $tempfile = $file->copy_content_to_temp('nctvideocodec');

        $filetocompress = $tempfile;
        $filetosave = make_temp_directory('nctvideocodec').'/compressed-'. $file->get_filename();

        $preset = get_config('local_nctvideocodec', 'compresspreset');

        $cmd = "node $CFG->dirroot" . "/local/nctvideocodec/js/compress.js " . escapeshellarg($filetocompress) . "  " . escapeshellarg($filetosave);
        $cmd .= " " . escapeshellarg($preset) . " 2>&1";

        exec($cmd, $output, $return);

        if ($return != 0) {
            // Handle error
            error_log("Error converting video to MP4: " . implode("\n", $output));
        }


        return $filetosave;
    }

    /**
     * Create the compressed file in user draft filearea, then copy the file to submission related filearea.
     *
     * @param string $compressed
     * @param stored_file $file
     * @return stored_file
     */
    protected static function create_user_draft($compressed, $file) {

        if (!file_exists($compressed)) {
            return false;
        }

        // Get file storage.
        $fs = get_file_storage();

        // Create file.
        $fileinfo = [
            'contextid' => \context_user::instance($file->get_userid())->id,   // ID of the context.
            'component' => 'user',         // Your component name.
            'filearea'  => 'draft',        // Usually = table name.
            'itemid'    => $file->get_itemid(),        // Usually = ID of row in table.
            'filepath'  => '/',            // Any path beginning and ending in /.
            'filename'  =>  $file->get_filename() . '.png',   // Any filename.
        ];

        // Delete all the files in the
        if (!empty($fileinfo['itemid'])) {
            $fs->delete_area_files($fileinfo['contextid'], $fileinfo['component'], $fileinfo['filearea'], $fileinfo['itemid']);
        }

        $storedfile = $fs->create_file_from_pathname($fileinfo, $compressed);

        return $storedfile;
    }
}
