<?php

require_once('../../config.php');
require_once($CFG->libdir . '/adminlib.php');

$url = new moodle_url('/local/nctvideocodec/setup.php');

$PAGE->set_url($url);

admin_externalpage_setup('nctvideocodecsetup');

echo $OUTPUT->header();

// Detect the operating system
$os = PHP_OS_FAMILY;
$error = false;

// Check if HandBrakeCLI and handbrake-js are installed.
if ($os === 'Linux') {
    // Check for HandBrakeCLI on Linux (not needed for Windows/macOS)
    $handbrakeclicheck = exec('which HandBrakeCLI 2>&1', $output1, $return);
    $handbrakeclicheck = exec('HandBrakeCLI --version 2>&1', $output2, $return);
    if (!empty($return)) {

        // exec('sudo apt-get install -y handbrake-cli 2>&1', $output, $return);

        if (!empty($output2)) {
            foreach ($output2 as $line) {
                $li[] = html_writer::tag('li', $line);
            }
            echo $OUTPUT->heading('Handbrake Cli:');
            echo $OUTPUT->notification(html_writer::tag('ul', implode('', $li)), 'error');
        }

        echo $OUTPUT->notification(get_string('issuehandbrakecli', 'local_nctvideocodec'), 'error', false);
        $error = true;
    }
}

$nodecheck = strtolower($os) == 'windows' ? exec('where node 2>&1', $output3, $return) : exec('which node 2>&1', $output3, $return);
if (!$nodecheck) {

    if (!empty($output3)) {
        foreach ($output3 as $line) {
            $li[] = html_writer::tag('li', $line);
        }

        echo $OUTPUT->heading('NPM Error');
        echo $OUTPUT->notification(html_writer::tag('ul', implode('', $li)), 'error');
    }

    if (!$nodecheck) {
        echo $OUTPUT->notification(get_string('nodenotinstalled', 'local_nctvideocodec'), "error", false);
    }
}

$dir = $CFG->dirroot;
// $handbrakejscheck = exec("cd $dir && npm list handbrake-js 2>&1", $output1, $return);
$handbrakejscheck = exec("cd $dir && npm list handbrake-js 2>&1", $output4, $return);

if (!empty($return)) {

    // exec("cd $dir && npm install handbrake-js 2>&1", $output2, $return);
    // echo "cd $dir && npm install handbrake-js";

    if (!empty($output4)) {
        foreach ($output4 as $line) {
            $li[] = html_writer::tag('li', $line);
        }

        echo $OUTPUT->heading('NPM Error');
        echo $OUTPUT->notification("npm install handbrake-js", 'error', false);
        echo $OUTPUT->notification(html_writer::tag('ul', implode('', $li)), 'error', false);
        echo $OUTPUT->notification(get_string('issuenode', 'local_nctvideocodec'), "error", false);
        $error = true;
    }
}

if (!$error) {
    echo $OUTPUT->heading(get_string('setupcompleted', 'local_nctvideocodec'));
    echo $OUTPUT->notification(get_string('installationseemsgood', 'local_nctvideocodec'), 'success', false);
    if (!get_config('local_nctvideocodec', 'enablecompression')) {
        echo $OUTPUT->notification(get_string('compressiondisabled', 'local_nctvideocodec'), 'warning', false);
    }
}

echo $OUTPUT->footer();
