define(['jquery', 'core/ajax'], function ($, AJAX) {


	var _initevents = function ($contextid) {

		$('body').delegate('#dropdown-child-tab li', 'click', function () {

			var val = $(this).attr('data-filter');
			var parentid = $(this).attr('data-parent');
			if (parentid === undefined) {
				parentid = false;
			}
			var courses = _loadcategorycourses(val, parentid);
			_generate_templates(courses);
		});

		$('body').delegate('.list-all-categories .list-item', 'click', function () {
			var categoryid = $(this).attr('data-filter');
			var parentid = false;
			var listitem = $(this).parent();
			$(listitem).find("li .nav-tab-role").each(function () {
				if ($(this).hasClass("active")) {
					$(this).removeClass("active");
				}
			});
			$(this).find(".nav-tab-role").addClass("active");
			var courses = _loadcategorycourses(categoryid, parentid);
		});

	},

		_loadcategorycourses = function (categoryid, parentid) {

			var request = {

				methodname: 'theme_edifi_get_category_courses',
				args: {
					categoryid: categoryid,
					parentid: parentid
				}

			};
			var promise = AJAX.call([request])[0];
			promise.done(function (result) {
				// var promise = Fragment.loadFragment(COMPONENT, methodname, 1, params ).then(function(result) {
				$('#combo-list-carousel').find('.carousel-inner').replaceWith(result.html);
				$('#combo-list-carousel').find('.carousel-item:first').addClass('active');
			})

			return promise;
		}

	_generate_templates = function (courses) {

	}


	return {

		init: function (contextid) {
			_initevents(contextid);
		}
	}

});