<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 *
 */

 defined('MOODLE_INTERNAL') || die();

/**
 * Return the set of values for Header Contents.
 * @return type|string
 */
function header_contents() {
    global $OUTPUT, $USER, $PAGE, $CFG, $SITE;

    $pcolor = theme_edifi_get_pattern_color('color');
    $PAGE->requires->data_for_js('edifiData', ['theme_color' => $pcolor] );
    require_once($CFG->libdir . '/behat/lib.php');
    // $drawer = theme_edifi_header_style('CENTER');
    if (isloggedin() && $PAGE->pagelayout != 'frontpage') {
        // $navdraweropen = false;
        $navdraweropen = (get_user_preferences('drawer-open-nav', 'true') == 'true');
    } else {
        $navdraweropen = false;
    }
    $extraclasses = [];
    $bodyattributes = $OUTPUT->body_attributes($extraclasses);
    $firstname = isset($USER->firstname) ? $USER->firstname : '';
    $logo_url = theme_edifi_get_logo_url();
    $surl = new moodle_url('/course/search.php');
    $surl_com = (! $PAGE->url->compare($surl, URL_MATCH_BASE)) ? 1 : 0;
    $searchcourses = get_string('searchcourses');
    $transparent = theme_edifi_get_setting('headerTransparent');
    $header_overlay = theme_edifi_get_setting('headerOverlay');
    if ($transparent == 1 && $PAGE->pagelayout == 'frontpage') {
        $headerOver_class = ($header_overlay == 1) ? 'bg_overlay' : '';
    } else {
        $headerOver_class = '';
    }
    if (!theme_edifi_get_setting('toggleslideshow')) {
        $transparent = false;
        $headerOver_class = '';
    }
    $header = theme_edifi_header_style();

    $centerMenu = $OUTPUT->custom_menu(null, "CENTER");
    $socialmedia = theme_edifi_social_media();
    $emailid = theme_edifi_get_setting('emailid');
    $phoneno = theme_edifi_get_setting('phoneno');
    $theme_loader = theme_edifi_get_loader();
    $langmenu = theme_edifi_get_lang();
    if (isloggedin() && !isguestuser()) {
        $loggedin = true;
    } else {
        $loggedin = false;
    }
    $stickylogo = theme_edifi_get_logo_url('sticky');
    $stickylogo = !empty($stickylogo) ? $stickylogo : '';
    // print_r($socialmedia);
    $templatecontext = [
        'bodyattributes' => $bodyattributes,
        'navdraweropen' => $navdraweropen,
        'logo_url' => $logo_url,
        'surl_com' => $surl_com,
        'surl' => $surl,
        'searchcourses' => $searchcourses,
        'transparentHeader' => $transparent,
        'headerStyle' => $header,
        'stickylogo' => $stickylogo,
        'centerMenu' => $centerMenu,
        'social' => $socialmedia,
        "headPhone" => $phoneno,
        "headEmail" => $emailid,
        'theme_loader' => $theme_loader,
        'langmenu' => $langmenu,
        'loggedin' => $loggedin,
        'headerOverclass' => $headerOver_class,

    ];
    return $templatecontext;
}
$headercontext = header_contents();



?>