<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 *
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Return the set of main center block values in array.
 * @return type|array
 */
function main_block() {
    global $CFG, $PAGE, $OUTPUT, $USER, $SITE;
    require_once($CFG->libdir . '/behat/lib.php');
    $drawer = theme_edifi_header_style('CENTER');
    if (isloggedin()) {
        $navdraweropen = (get_user_preferences('drawer-open-nav', 'true') == 'true');
    } else {
        $navdraweropen = false;
    }
    $extraclasses = [];
    $bodyattributes = $OUTPUT->body_attributes( $extraclasses);
    $blockshtml = $OUTPUT->blocks('side-pre');
    $hasblocks = strpos($blockshtml, 'data-block=') !== false;
    $regionmainsettingsmenu = $OUTPUT->region_main_settings_menu();
    $firstname = isset($USER->firstname) ? $USER->firstname : '';
    $logo_url = theme_edifi_get_logo_url();
    $surl = new moodle_url('/course/search.php');
    $surl_com = (! $PAGE->url->compare($surl, URL_MATCH_BASE)) ? 1 : 0;
    $searchcourses = get_string('searchcourses');

    // Footer Content variables
    $regioncalendar = $PAGE->blocks->region_has_content('calendar', $OUTPUT);

    $footnote = theme_edifi_get_setting('footnote', 'format_html');
    $copyright = theme_edifi_get_setting('copyright', true);
    $fburl = theme_edifi_get_setting('fburl');
    $pinurl = theme_edifi_get_setting('pinurl');
    $twurl = theme_edifi_get_setting('twurl');
    $gpurl = theme_edifi_get_setting('gpurl');
    $address = theme_edifi_get_setting('address');
    $emailid = theme_edifi_get_setting('emailid');
    $phoneno = theme_edifi_get_setting('phoneno');
    $s_calendar = get_string('calendar', 'theme_edifi');
    $s_about = get_string('about', 'theme_edifi');
    $s_contact = get_string('contact', 'theme_edifi');
    $s_phone = get_string('phone');
    $s_emailid = get_string('emailid', 'theme_edifi');
    $s_connectus = get_string('connectus', 'theme_edifi');
    $s_home = get_string('home');
    $s_aboutus = get_string('aboutus', 'theme_edifi');
    $s_editmyprofile = get_string('editmyprofile');
    $s_sitenews = get_string('sitenews');
    $s_logout = get_string('logout');
    $s_signup = get_string('signup', 'theme_edifi');
    $s_sitenews = get_string('sitenews');
    $s_login = get_string('login');
    $loginurl = new moodle_url("/login/index.php");
    $signupurl = new moodle_url("/login/signup.php");
    $authcheck = (($CFG->registerauth == 'email') || !empty($CFG->registerauth)) ? 1 : 0;
    $logouturl = new moodle_url('/login/logout.php', array('sesskey' => sesskey(), 'alt' => 'logout'));
    $editurl = new moodle_url('/user/edit.php', array('id' => $USER->id));
    $backToTop_status = theme_edifi_get_setting('backToTop_status');
    $footerLogo = theme_edifi_footer_logo();
    $footer = theme_edifi_footer_blocks();
    if(isloggedin())
        $loggin = 1;
    else
        $loggin = 0;
    $www = $CFG->wwwroot;

    $secondarynavigation = false;
    if (!defined('BEHAT_SITE_RUNNING')) {
        $buildsecondarynavigation = $PAGE->has_secondary_navigation();
        if ($buildsecondarynavigation) {
            $moremenu = new \core\navigation\output\more_menu($PAGE->secondarynav, 'nav-tabs');
            $secondarynavigation = $moremenu->export_for_template($OUTPUT);
        }
    }

    $templatecontext = [
        'sitename' => format_string($SITE->shortname, true, ['context' => context_course::instance(SITEID), "escape" => false]),
        'output' => $OUTPUT,
        'sidepreblocks' => $blockshtml,
        'hasblocks' => $hasblocks,
        'bodyattributes' => $bodyattributes,
        'navdraweropen' => $navdraweropen,
        'regionmainsettingsmenu' => $regionmainsettingsmenu,
        'hasregionmainsettingsmenu' => !empty($regionmainsettingsmenu),
        'secondarymoremenu' => $secondarynavigation,
        'logo_url' => $logo_url,
        'surl_com' => $surl_com,
        'surl' => $surl,
        'searchcourses' => $searchcourses,
        "regioncalendar" => $regioncalendar,
        "footnote" => $footnote,
        "copyright" => $copyright,
        "fburl" => $fburl,
        "pinurl" => $pinurl,
        "twurl" => $twurl,
        "gpurl" => $gpurl,
        "address" => $address,
        "emailid" => $emailid,
        "phoneno" => $phoneno,
        "s_calendar" => $s_calendar,
        "s_about" => $s_about,
        "s_contact" => $s_contact,
        "s_phone" => $s_phone,
        "s_emailid" => $s_emailid,
        "s_connectus" => $s_connectus,
        "s_home" => $s_home,
        "s_aboutus" => $s_aboutus,
        "s_editmyprofile" => $s_editmyprofile,
        "s_sitenews" => $s_sitenews,
        "s_logout" => $s_logout,
        "s_signup" => $s_signup,
        "s_sitenews" => $s_sitenews,
        "s_login" => $s_login,
        "loginurl" => $loginurl,
        "signupurl" => $signupurl,
        "authcheck" => $authcheck,
        "logouturl" => $logouturl,
        "editurl" => $editurl,
    ];
    $templatecontext['flatnavigation'] = $PAGE->flatnav;
    return $templatecontext;
}
?>