<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 *
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Theme_edifi install function.
 *
 * @return void
 */
function xmldb_theme_edifi_install() {
    global $CFG;

    if (method_exists('core_plugin_manager', 'reset_caches')) {
        core_plugin_manager::reset_caches();
    }
    $loggedin = get_config('moodle', 'frontpageloggedin');
    $explog = array('6', '2', '5', '7', '4', '0');
    $data = array( 's__frontpageloggedin' => $explog );
    admin_write_settings($data);
    $explog = array('6', '2', '7', '4', '0');
    $data = array( 's__frontpage' => $explog );
    admin_write_settings($data);

    // Set the default background.
    $fs = get_file_storage();

    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid    = get_admin()->id;
    $filerecord->filearea  = 'logo';
    $filerecord->filepath  = '/';
    $filerecord->itemid    = 0;
    $filerecord->filename  = 'logo.png';

    $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/logo.png');
        set_config('logo', '/logo.png', 'theme_edifi');
    }

    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid    = get_admin()->id;
    $filerecord->filearea  = 'loginbg';
    $filerecord->filepath  = '/';
    $filerecord->itemid    = 0;
    $filerecord->filename  = 'loginbg.jpg';

    $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/loginbg.jpg');
        set_config('loginbg', '/loginbg.jpg', 'theme_edifi');

    }

    // Login bg.
    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid    = get_admin()->id;
    $filerecord->filearea  = 'stickylogo';
    $filerecord->filepath  = '/';
    $filerecord->itemid    = 0;
    $filerecord->filename  = 'stickylogo.png';
     $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/stickylogo.png');
        set_config('stickylogo', '/stickylogo.png', 'theme_edifi');
    }

    // Footer logo.
    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid    = get_admin()->id;
    $filerecord->filearea  = 'footerlogo';
    $filerecord->filepath  = '/';
    $filerecord->itemid    = 0;
    $filerecord->filename  = 'footerlogo.png';
     $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/stickylogo.png');
        set_config('footerlogo', '/footerlogo.png', 'theme_edifi');
    }

    // Slider images.
    $i = 1;
    $fs = get_file_storage();
    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid = get_admin()->id;
    $filerecord->filearea = 'slide1image';
    $filerecord->filepath = '/';
    $filerecord->itemid = 0;
    $filerecord->filename = 'slide1image.jpg';
     $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/slide1.jpg');
        set_config('slide1image', '/slide1image.jpg', 'theme_edifi');
    }

    // Footer background Image.
    $fs = get_file_storage();
    $filerecord = new stdClass();
    $filerecord->component = 'theme_edifi';
    $filerecord->contextid = context_system::instance()->id;
    $filerecord->userid    = get_admin()->id;
    $filerecord->filearea  = 'counterbg_image';
    $filerecord->filepath  = '/';
    $filerecord->itemid    = 0;
    $filerecord->filename  = 'counterbg.jpg';
     $exist = record_exsist($filerecord);
    if ($exist != 1) {
        $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/counterbg.jpg');
        set_config('counterbg_image', '/counterbg.jpg', 'theme_edifi');
    }

    for ($s = 1; $s <= 4; $s++) {
        
        $fs = get_file_storage();
        $filerecord = new stdClass();
        $filerecord->component = 'theme_edifi';
        $filerecord->contextid = context_system::instance()->id;
        $filerecord->userid    = get_admin()->id;
        $filerecord->filearea  = 'sitefblock'.$s.'image';
        $filerecord->filepath  = '/';
        $filerecord->itemid    = 0;
        $filerecord->filename  = 'sitefblock'.$s.'image.png';
        $exist = record_exsist($filerecord);
        if ($exist != 1) {
            $fs->create_file_from_pathname($filerecord, $CFG->dirroot . '/theme/edifi/pix/home/sitefblock'.$s.'image.png');
            set_config('sitefblock'.$s.'image', '/sitefblock'.$s.'image.png', 'theme_edifi');
        }
    }

    for ($p = 1; $p <= 8; $p++) {

        $fs = get_file_storage();
        $filerecord = new stdClass();
        $filerecord->component = 'theme_edifi';
        $filerecord->contextid = context_system::instance()->id;
        $filerecord->userid = get_admin()->id;
        $filerecord->filearea = 'partner'.$p.'img';
        $filerecord->filepath = '/';
        $filerecord->itemid = 0;
        $filerecord->filename = 'partner'.$p.'img.png';
        $exist = record_exsist($filerecord);
        if ($exist != 1) {
            $fs->create_file_from_pathname($filerecord,$CFG->dirroot . '/theme/edifi/pix/partner/partner'.$p.'img.png');
            set_config('partner'.$p.'img','/partner'.$p.'img.png','theme_edifi');
        }

    }



}

function record_exsist($filerecord) {
        $fs = get_file_storage();
        $exist = $fs->file_exists($filerecord->contextid, $filerecord->component, $filerecord->filearea, $filerecord->itemid, $filerecord->filepath, $filerecord->filename);
        return $exist;
}