<?php
 //
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

define('EDIFIFRONTPAGEFEATURECOURSES', 11);
define('EDIFIFRONTPAGEFEATURES', 12);
define('EDIFIFRONTPAGESITEEVENTS', 13);
define('EDIFIFRONTPAGETESTIMONIALS', 14);
define('EDIFIFRONTPAGECOUNTERS', 15);
define('EDIFIFRONTPAGEPARTNERS', 16);

/**
 * Load theme main scss contents.
 * @param type|string $theme
 * @return type|string
 */
function theme_edifi_get_main_scss_content($theme) {
    global $CFG;
    $scss = '';
    $parentconfig = theme_config::load('boost');
    $scss .= theme_boost_get_main_scss_content($parentconfig);
    $fs = get_file_storage();
    $context = context_system::instance();
    $scss .= file_get_contents($CFG->dirroot . '/theme/edifi/scss/edifi.scss');
    return $scss;
}

/**
 * Get the custom scss and add the scss into main scss.
 * @param type $theme
 * @return type
 */


/**
 * Get the configuration values into main scss variables.
 * @param type|string $theme
 * @return type|string
 */

/**
 * Get the theme pattern color from the theme configuration.
 * @return type|string
 */
    function theme_edifi_get_pattern_color($type = '') {

    $pattern = array( "rose" => "#ff5252", "yellow" => "#ffa000", "darkblue" => "#293694", "green" => "#7abb3b", "orange" => "#e8580c" );
    $patternstatus = theme_edifi_get_setting('patternselect');
    if ($patternstatus != "custom") {
        $pselect = theme_edifi_get_setting('patternselect');
        $pselect = (!empty($pselect)) ? $pselect : 'red';
        $color = isset($pattern[$pselect]) ? $pattern[$pselect] : "#ff5252";
        $color = !empty($color) ? $color : '#ff5252';
    } else {
        $pcolor = theme_edifi_get_setting('patterncolor');
        $color = !empty($pcolor) ? $pcolor : "#ff5252";
    }
    if (empty($type)) {
        return '$patternselect:'.$color.";\n";
    } else {
        return $color;
    }
}

/**
 * Get the slide height from theme settings and add into the main scss .
 * @param type|string $theme
 * @return type|string
 */
function theme_edifi_set_slide_height($theme) {
    if (!empty($theme->settings->slideHeight)) {
        $height = $theme->settings->slideHeight;
        $height = intval($height);
        if ($height == "" || $height > "1300" || $height < "300") {
            $height = "550px";
        } else {
            $height = $height."px";
        }
    } else {
        $height = "600px";
    }
    $slideHeight = '$slideHeight:'. $height . ";\n";
    return $slideHeight;
}
/**
 * Get the theme header height from theme options and add into the scss.
 * @param type|string $theme
 * @return type|string
 */
function theme_edifi_header_height($theme) {
    $height = "";
    if (!empty($theme->settings->headerHeight) ) {
        $height = $theme->settings->headerHeight;
        $height = intval($height);
     }
    if (!is_numeric($height) || empty($height) ) {
        $height = "75px";
    } else {
        $height = $height."px";
    }
    
    return $height;
}

/**
 * Load all configurable image url into the scss content.
 * @param type|string $theme
 * @param type|string $scss
 * @return type
 */

/**
 * Loads the CSS and set the background images.
 *
 * @param type|string $css
 * @param type|string $bgimage
 * @param type|string $setting
 * @return type|string
 */
function theme_edifi_set_bgimg($configkey, $value) {

    global $CFG;

    $url = "";
    if ((empty($value) || $value == null) && !empty($configkey)) {
        $url = $CFG->wwwroot.'/theme/edifi/pix/home/'.$configkey;
    } else {
        $url = $value;
    }
    $imgCss = "url('".$url."')";

    return $imgCss;

}

function edifi_grid($hassidepre, $hassidepost) {

    if ($hassidepre && $hassidepost) {
                                $regions = array('content' => 'col-sm-8 col-sm-push-4 col-lg-9 col-lg-push-3');
        $regions['pre'] = 'col-sm-4 col-sm-pull-8 col-lg-3 col-lg-pull-9';
        $regions['post'] = 'col-sm-4 col-lg-3';
    } else if ($hassidepre && !$hassidepost) {
        $regions = array('content' => 'col-sm-8 col-sm-push-4 col-lg-9 col-lg-push-3');
        $regions['pre'] = 'col-sm-4 col-sm-pull-8 col-lg-3 col-lg-pull-9';
        $regions['post'] = 'emtpy';
    } else if (!$hassidepre && $hassidepost) {
        $regions = array('content' => 'col-sm-9 col-lg-10');
        $regions['pre'] = 'empty';
        $regions['post'] = 'col-sm-3 col-lg-2';
    } else if (!$hassidepre && !$hassidepost) {
        $regions = array('content' => 'col-md-12');
        $regions['pre'] = 'empty';
        $regions['post'] = 'empty';
    }
    return $regions;
}

/**
 * Loads the CSS Styles and put the font path
 *
 * @param $css
 * @return type|string
 */
function theme_edifi_set_fontwww1() {

    global $CFG, $PAGE;

    if (empty($CFG->themewww)) {
        $themewww = $CFG->wwwroot."/theme";
    } else {
        $themewww = $CFG->themewww;
    }
    $url = $themewww.'/edifi/fonts/';
    $scss = '$fontwww: "'. $url .'"'. ";\n";
    return $scss;

}

/**
 * Set the font folder url into css fonts value.
 * @param type|string $css
 * @return type|string $css
 */
function theme_edifi_set_fontwww($css) {
    global $CFG, $PAGE;
    if (empty($CFG->themewww)) {
        $themewww = $CFG->wwwroot."/theme";
    } else {
        $themewww = $CFG->themewww;
    }
    $tag = '[[setting:fontwww]]';
    $theme = theme_config::load('edifi');
    $css = str_replace($tag, $themewww.'/edifi/fonts/', $css);
    return $css;

}


function theme_edifi_set_css_headerhight($css,$theme){

    global $CFG,$PAGE;
    
    $tag = '[[headerheight]]';
    $headerhight = theme_edifi_header_height($theme);
    $replacement = $headerhight;
    $css = str_replace($tag, $replacement,$css);
    return $css;
    
}

/**
 * Loads the CSS Styles and replace the background images.
 * If background image not available in the settings take the default images.
 *
 * @param type|string $css
 * @param type|string $theme
 * @return type|string
 */
function theme_edifi_process_css($css, $theme) {

    global $OUTPUT;
    // Set the font path.
    if (!empty($theme->settings->customcss)) {

        $customcss = $theme->settings->customcss;

    } else {
        $customcss = null;
    }

    $bgimages = ['counterbg_image','loginbg'];

    foreach($bgimages as $bgimg){

        $setting = $bgimg;
        $bgimage = $theme->setting_file_url($setting,$setting);

        if (empty($bgimage)) {
            $bgimage = '';
        }
        $css = theme_edifi_bgload_image($css,$setting,$bgimage);

    }

    $css = theme_edifi_custom_css($css,$customcss);
    $css = theme_edifi_set_fontwww($css);
    $css = theme_edifi_set_css_headerhight($css,$theme);
    $css = theme_edifi_set_header_color($css,$theme);
    $css = theme_edifi_set_slider_height($css, $theme);

    return $css;
}


function theme_edifi_bgload_image($css,$setting,$bgimage){

    $tag = '[['.$setting.']]';
    $replacement = $bgimage;
    $css = str_replace($tag,$replacement,$css);
    return $css;
}

function theme_edifi_custom_css($css,$customcss){

    $tag = '[[setting:customcss]]';
    $replacement = $customcss;
    if (is_null($replacement)) {
        $replacement = '';
    }
    $css = str_replace($tag, $replacement,$css);
    return $css;
}


function theme_edifi_set_header_color($css,$theme){

    $pattern = array( "rose" => "#ff5252", "yellow" => "#ffa000", "darkblue" => "#293694", "green" => "#7abb3b", "orange" => "#e8580c" );
    $patternstatus = theme_edifi_get_setting('patternselect');
    if ($patternstatus != "custom") {
        $pselect = theme_edifi_get_setting('patternselect');
        $pselect = (!empty($pselect)) ? $pselect : 'red';
        $color = isset($pattern[$pselect]) ? $pattern[$pselect] : "#ff5252";
        $color = !empty($color) ? $color : '#ff5252';
    } else {
        $pcolor = theme_edifi_get_setting('patterncolor');
        $color = !empty($pcolor) ? $pcolor : "#ff5252";
    }
    
    $tag = 'var(--patternselect)';
    $replacement = $color;
    $css = str_replace($tag,$replacement,$css);
    return $css; 
   
}

function theme_edifi_set_slider_height($css, $theme) {

    if (!empty($theme->settings->slideHeight)) {
        $height = $theme->settings->slideHeight;
        $height = intval($height);
        if ($height == "" || $height > "1300" || $height < "300") {
            $height = "550px";
        } else {
            $height = $height."px";
        }
    } else {
        $height = "600px";
    }

    $tag = 'var(--slider_height)';
    $replacement = $height;
    $css = str_replace($tag, $replacement, $css);
    return $css;
}



function theme_edifi_set_color() {
    $content = '';
     $acolor = array('sitefblock1bgcolor' => '#fff', 'sitefblock2bgcolor' => '#fff', 'sitefblock3bgcolor' => '#fff', 'sitefblock4bgcolor' => '#fff', 'slidecapbgcolor' => '#f47264', 'slidecapcolor' => '#fff', 'slidelinkbgcolor' => '#1d69a5', 'slidelinkcolor' => '#fff' );

    foreach ($acolor as $configkey => $dcolor) {
        $color_val = theme_edifi_get_setting($color);
        if (empty($color_val)) {
            $color_val = $dcolor;
        }
        $content .= '$'. $configkey .':'. $color_val .";\n";
    }
    return $content;
}

/**
 * Return the theme setting value
 * Check the return format type and return appropriate content
 *
 * @param $setting
 * @param $format
 * @return type|string
 */
function theme_edifi_get_setting($setting, $format = true) {
    global $CFG;
    require_once($CFG->dirroot . '/lib/weblib.php');
    static $theme;
    if (empty($theme)) {
        $theme = theme_config::load('edifi');
    }
    if (empty($theme->settings->$setting)) {
        return false;
    } else if (!$format) {
        return $theme->settings->$setting;
    } else if ($format === 'format_text') {
        return format_text($theme->settings->$setting, FORMAT_PLAIN);
    } else if ($format === 'format_html') {
        return format_text($theme->settings->$setting, FORMAT_HTML, array('trusted' => true, 'noclean' => true));
    } else {
        return format_string($theme->settings->$setting);
    }
}

/**
 * Return the current theme url
 * @return type|string
 */
if (!function_exists('theme_url')) {
    function theme_url() {
        global $CFG, $PAGE;
        $theme_url = $CFG->wwwroot.'/theme/'. $PAGE->theme->name;
        return $theme_url;
    }
}

/**
 * Serves any files associated with the theme settings.
 *
 * @param stdClass $course
 * @param stdClass $cm
 * @param context $context
 * @param string $filearea
 * @param array $args
 * @param bool $forcedownload
 * @param array $options
 * @return bool
 */
function theme_edifi_pluginfile($course, $cm, $context, $filearea, $args, $forcedownload, array $options = array()) {
    static $theme;
                $bgimgs = array('homebanner', 'footbgimg', 'sitefeaturebg', 'newseventbg', 'testimonialsbg','counterbg_image','loginbg');

    if (empty($theme)) {
        $theme = theme_config::load('edifi');
    }

    if ($context->contextlevel == CONTEXT_SYSTEM) {

        if ($filearea === 'logo') {
            return $theme->setting_file_serve('logo', $args, $forcedownload, $options);
        } else if ($filearea === 'style') {
            theme_edifi_serve_css($args[1]);
        } else if ($filearea === 'pagebackground') {
            return $theme->setting_file_serve('pagebackground', $args, $forcedownload, $options);
            
        } else if (preg_match("/sitefblock[1-9][0-9]*image/",$filearea) !== false) {
            return $theme->setting_file_serve($filearea, $args, $forcedownload, $options);
        }
        else if (preg_match("/slide[1-9][0-9]*image/", $filearea) !== false) {
            return $theme->setting_file_serve($filearea, $args, $forcedownload, $options);
        } else if ($filearea === 'footbgimg') {
            return $theme->setting_file_serve('footbgimg', $args, $forcedownload, $options);
        } else if ($filearea === 'homebanner') {
            return $theme->setting_file_serve('homebanner', $args, $forcedownload, $options);
        } else if (in_array($filearea, $bgimgs)) {
            return $theme->setting_file_serve($filearea, $args, $forcedownload, $options);
        } else {
            send_file_not_found();
        }
    } else {
        send_file_not_found();
    }
}

/**
 * Serves CSS for image file updated to styles.
 *
 * @param string $filename
 * @return string
 */
function theme_edifi_serve_css($filename) {
    global $CFG;
    if (!empty($CFG->themedir)) {
        $thestylepath = $CFG->themedir . '/edifi/style/';
    } else {
        $thestylepath = $CFG->dirroot . '/theme/edifi/style/';
    }
    $thesheet = $thestylepath . $filename;

    $etagfile = md5_file($thesheet);
    // File.
    $lastmodified = filemtime($thesheet);
    // Header.
    $ifmodifiedsince = (isset($_SERVER['HTTP_IF_MODIFIED_SINCE']) ? $_SERVER['HTTP_IF_MODIFIED_SINCE'] : false);
    $etagheader = (isset($_SERVER['HTTP_IF_NONE_MATCH']) ? trim($_SERVER['HTTP_IF_NONE_MATCH']) : false);

    if ((($ifmodifiedsince) && (strtotime($ifmodifiedsince) == $lastmodified)) || $etagheader == $etagfile) {
        theme_edifi_send_unmodified($lastmodified, $etagfile);
    }
    theme_edifi_send_cached_css($thestylepath, $filename, $lastmodified, $etagfile);
}

// Set browser cache used in php header.
function theme_edifi_send_unmodified($lastmodified, $etag) {
    $lifetime = 60 * 60 * 24 * 60;
    header('HTTP/1.1 304 Not Modified');
    header('Expires: ' . gmdate('D, d M Y H:i:s', time() + $lifetime) . ' GMT');
    header('Cache-Control: public, max-age=' . $lifetime);
    header('Content-Type: text/css; charset=utf-8');
    header('Etag: "' . $etag . '"');
    if ($lastmodified) {
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $lastmodified) . ' GMT');
    }
    die;
}

// Cached css.
function theme_edifi_send_cached_css($path, $filename, $lastmodified, $etag) {
    global $CFG;
    require_once($CFG->dirroot . '/lib/configonlylib.php'); // For min_enable_zlib_compression().
    // 60 days only - the revision may get incremented quite often.
    $lifetime = 60 * 60 * 24 * 60;

    header('Etag: "' . $etag . '"');
    header('Content-Disposition: inline; filename="'.$filename.'"');
    header('Last-Modified: ' . gmdate('D, d M Y H:i:s', $lastmodified) . ' GMT');
    header('Expires: ' . gmdate('D, d M Y H:i:s', time() + $lifetime) . ' GMT');
    header('Pragma: ');
    header('Cache-Control: public, max-age=' . $lifetime);
    header('Accept-Ranges: none');
    header('Content-Type: text/css; charset=utf-8');
    if (!min_enable_zlib_compression()) {
        header('Content-Length: ' . filesize($path . $filename));
    }

    readfile($path . $filename);
    die;
}

/**
 * Logo Image URL Fetch from theme settings
 *
 * @return string
 */
if (!function_exists('theme_edifi_get_logo_url')) {

    function theme_edifi_get_logo_url($sticky = '') {
        global $OUTPUT;
        static $theme;
        if (empty($theme)) {
            $theme = theme_config::load('edifi');
        }
        if ($sticky == 'sticky') {
            $logo = $theme->setting_file_url('stickylogo', 'stickylogo');
            return $logo;
        } else {
            $logo = $theme->setting_file_url('logo', 'logo');
            $logo = empty($logo) ? "" : $logo;
            return $logo;
        }
    }
}

/**
 * Load the Jquery and migration files
 * Load the our theme js file
 * Add Page body classes.
 */
function theme_edifi_page_init(moodle_page $page) {
    global $CFG,$PAGE;
    $page->requires->jquery();
    $transparent = theme_edifi_get_setting('headerTransparent');
    $PAGE->requires->js('/theme/edifi/javascript/theme.js');
    if (!$transparent || $page->pagelayout != 'frontpage' ) {
        $page->add_body_class('header-bg-block');
        $section = optional_param('section', '', PARAM_TEXT);
        if ( $section == 'themesettingedifi') {
            $page->add_body_class('theme-floating-btn');
        }
    }
    if (is_siteadmin()) {
        $page->add_body_class('site-news-admin');
    }
    if (!theme_edifi_get_setting('toggleslideshow')) {
        $page->add_body_class('carousel-inactive');
    }
    if (theme_edifi_get_setting('headerStyle') != '2') {
        $page->add_body_class('header-left-logo');
    }
    $importDemo = isset($page->theme->settings->importDemo) ? $page->theme->settings->importDemo : "0";
    if ( $importDemo == "1") {
        if (file_exists($CFG->dirroot.'/theme/edifi/classes/demoImporter.php')) {
            // $class = new \theme_edifi\edifiDemoImport;
            require_once($CFG->dirroot.'/theme/edifi/classes/demoImporter.php');
            $class = new edifiDemoImport();

        }
    }
}

/*function site(){
    global $CFG, $COURSE;
    require_once $CFG->dirroot.'/mod/forum/externallib.php';

    $forum = $DB->get_record('forum', array('id' => 7), '*', MUST_EXIST);
    list($course, $cm) = get_course_and_cm_from_instance($forum, 'forum');
    $options = array(
            'discussionsubscribe' => true,
            'discussionpinned' => false,
            'inlineattachmentsid' => 0,
            'attachmentsid' => null
        );
    $discussion = new stdClass();
    $discussion->course = $course->id;
    $discussion->forum = $forum->id;
    $discussion->message = "Cheking content from the external api used message.";
    $discussion->messageformat = FORMAT_HTML;   // Force formatting for now.
    // $discussion->messagetrust = trusttext_trusted($context);
    $discussion->itemid = $options['inlineattachmentsid'];
    $discussion->groupid = $groupid;
    $discussion->mailnow = 0;
    $discussion->subject = "Cheking content from the external api used subject";
    $discussion->name = $discussion->subject;
    $discussion->timestart = 0;
    $discussion->timeend = 0;
    $discussion->attachments = $options['attachmentsid'];
     if (has_capability('mod/forum:pindiscussions', $context) && $options['discussionpinned']) {
            $discussion->pinned = FORUM_DISCUSSION_PINNED;
    } else {
        $discussion->pinned = FORUM_DISCUSSION_UNPINNED;
    }
    $fakemform = $options['attachmentsid'];
    if ($discussionid = forum_add_discussion($discussion, $fakemform)) {
        echo $discussionid;
    }
}*/

function theme_edifi_render_slideimg($p, $sliname) {
    global $PAGE, $OUTPUT, $CFG;

    $nos = theme_edifi_get_setting('numberofslides');

    $slideimage = $OUTPUT->image_url('home/slide'.$p, 'theme');

    $slideimage1 = $CFG->dirroot.'/theme/edifi/pix/home/slide'.$p.'.jpg';
    if(!file_exists($slideimage1))
        $slideimage = false;
    // Get slide image or fallback to default.
    if (theme_edifi_get_setting($sliname)) {
        $slideimage = $PAGE->theme->setting_file_url($sliname , $sliname);
    }
    if (empty($slideimage)) {
        $slideimage = false;
    }

    return $slideimage;
}

function theme_edifi_render_coursecreators() {
    global $CFG, $PAGE, $OUTPUT, $DB, $USER;
    $disp = '';
    $context = context_system::instance();
    $coursecreators = get_role_users( 2, $context);
    $disp .= '<div class="site-showcase"> <div class="container"> <div class="title-row"><h2>'.get_string('meet_our', 'theme_edifi').get_string("course_creators", "theme_edifi").'</h2></div> <div class="row panellist">';
    $i = 1;
    foreach ($coursecreators as $coursecreator) {
        $disp .= '<div class="col-lg-6 col-md-6 col-sm-6"> <div class="panel"> <div class="panel-body">';

        $uid  = $coursecreator->id;
        $pic = $OUTPUT->user_picture($coursecreator, array('size' => 94));

        $user = $DB->get_record('user', array('id' => $uid));
        $usercontext = context_user::instance($uid, MUST_EXIST);
        $currentuser = ($user->id == $USER->id);

        $disp .= '<div class="thumbnail">';
        $disp .= $pic;
        $disp .= '</div>';

        $disp .= '<div class="panel-desc">';

        if ($user->description && !isset($hiddenfields['description'])) {
            if (!empty($CFG->profilesforenrolledusersonly) && !$currentuser &&
                            !$DB->record_exists('role_assignments', array('userid' => $user->id))) {
                $disp .= get_string('profilenotshown', 'moodle');
            } else {
                $user->description = file_rewrite_pluginfile_urls($user->description, 'pluginfile.php', $usercontext->id, 'user', 'profile', null);
                $options = array('overflowdiv' => true);
                // $disp .= format_text($user->description, $user->descriptionformat, $options);
                $user_desc = format_string($user->description, $striplinks = true);
                $user_desc = course_trim_char($user_desc, 215);
                $disp .= '<p>'.$user_desc.'</p>';
            }
        }
        $disp .= '</div>';
        // desc end.
        $disp .= '<div class="clearfix"></div> </div> </div> </div>';

        if ($i % 2 == "0") {
            $disp .= '<div class="clearfix"></div>';
        }
        $i++;
    }

    $disp .= '</div></div> </div>';

    return  $disp;
}



/**
 * Remove the html special tags from course content.
 * This function used in course home page.
 *
 * @param string $text
 * @return string
 */
if (!function_exists('strip_html_tags')) {
    function strip_html_tags( $text ) {
        $text = preg_replace(
            array(
                // Remove invisible content
                    '@<head[^>]*?>.*?</head>@siu',
                    '@<style[^>]*?>.*?</style>@siu',
                    '@<script[^>]*?.*?</script>@siu',
                    '@<object[^>]*?.*?</object>@siu',
                    '@<embed[^>]*?.*?</embed>@siu',
                    '@<applet[^>]*?.*?</applet>@siu',
                    '@<noframes[^>]*?.*?</noframes>@siu',
                    '@<noscript[^>]*?.*?</noscript>@siu',
                    '@<noembed[^>]*?.*?</noembed>@siu',
                // Add line breaks before and after blocks
                    '@</?((address)|(blockquote)|(center)|(del))@iu',
                    '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
                    '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
                    '@</?((table)|(th)|(td)|(caption))@iu',
                    '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
                    '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
                    '@</?((frameset)|(frame)|(iframe))@iu',
            ),
            array(
                    ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
                    "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
                    "\n\$0", "\n\$0",
            ),
        $text );
        return strip_tags( $text );
    }
}

/**
 * Cut the Course content.
    *
    * @param $str
    * @param $n
    * @param $end_char
    * @return string
 */
if (!function_exists('course_trim_char')) {

    function course_trim_char($str, $n = 500, $end_char = '&#8230;') {

        if (strlen($str) < $n) {
            return $str;
        }

        $str = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $str));

        if (strlen($str) <= $n) {
            return $str;
        }
        $out = "";
        $small = substr($str, 0, $n);
        $out = $small.$end_char;
        return $out;
    }
}

/**
 * Event Trigger.
 *
 * If course updated after this function call automatically
 * @param course $eventdata
 */
if (!function_exists('neph_update_course')) {
    function neph_update_course($eventdata) {
        $course_id = $eventdata->id;
        $visible   = $eventdata->visible;
        /* Write your code here */
    }
}

/**
 * Event Trigger.
 *
 * If course deleted after this function call automatically
 * @param course $eventdata
 */
if (!function_exists('neph_delete_course')) {
    function neph_delete_course($eventdata) {
        $course_id = $eventdata->id;
        $visible   = $eventdata->visible;
        /* updated the featured course values */
        $featured_courses = get_config('theme_edifi', 'featured_courses');
        $afeatured_courses = explode(",", $featured_courses);
        $pos = array_search($course_id, $afeatured_courses);
        if ($pos !== false) {
            unset($afeatured_courses[$pos]);
            set_config('featured_courses', implode(',', $afeatured_courses), 'theme_edifi');
            if (method_exists('core_plugin_manager', 'reset_caches')) {
                core_plugin_manager::reset_caches();
            }
        }

    }
}

/**
* Fetch the hide course ids
*
* @return array
*/
if (!function_exists('hidden_courses_id')) {

    function hidden_courses_id() {
        global $DB;
        $hcourse_ids = array();
        $result = $DB->get_records_sql("SELECT id FROM {course} WHERE visible='0' ");
        if (!empty($result)) {
            foreach ($result as $row) {
                $hcourse_ids[] = $row->id;
            }
        }
        return $hcourse_ids;
    }
}

/**
 * Process the theme www url.
 * @return type|string
 */
function theme_edifi_theme_url() {
     global $CFG, $PAGE;
    $themeurl = $CFG->wwwroot.'/theme/'. $PAGE->theme->name;
    return $themeurl;
}

/**
 * Get the language string from the lang file.
 * @param type|string $key
 * @return type
 */
function theme_edifi_lang($key='') {
    $pos = strpos($key, 'lang:');
    if ($pos !== false) {
        list($l, $k) = explode("lang:", $key);
        $k = trim(strip_tags($k));
        if (get_string_manager()->string_exists($k, 'theme_edifi')) {
            $v = get_string($k, 'theme_edifi');
            return $v;
        } else {
            return $key;
        }
    } else {
        return $key;
    }
}

function get_course_content($course_id) {
    global $OUTPUT, $CFG;
    $courseId = intval($course_id);
    $course = get_course($courseId);

    if(!empty($course)):
        $noimgurl = $OUTPUT->image_url('no-image', 'theme');
        $data['url'] = new moodle_url('/course/view.php', array('id' => $courseId ));
        if ($course instanceof stdClass) {
        // require_once($CFG->libdir. '/coursecatlib.php');
            $course = new core_course_list_element($course);
        }
        $imgurl = '';
        $data['name'] = $course->get_formatted_name();
        $data['summary'] = strip_html_tags($course->summary);
        // $data['summary'] = course_trim_char($summary, 75);
        // include( $CFG->libdir.'/accesslib.php' );
        // $context_course = new context_course;
        $context = context_course::instance($course->id);
        $data['students'] = count_role_users(5, $context);
        foreach ($course->get_course_overviewfiles() as $file) {
            $isimage = $file->is_valid_image();
            $data['imgurl'] = file_encode_url("$CFG->wwwroot/pluginfile.php",
                '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
            if (!$isimage) {
                $data['imgurl'] = $noimgurl;
            }
        }
        if (empty($data['imgurl'])) {
            $data['imgurl'] = $noimgurl;
        }
    endif;
    return $data;
}


function check_length1($value, $length) {

    if (strlen($value) <= $length) {
        return $value;
    } else {
        $content = substr($value, 0, $length) . '...';
        return $content;
    }
}
/**
 * Get and return the selected header styles.
 * @param type|string $style
 * @return type
 */
function theme_edifi_header_style($style = "") {
    $headerStyle = theme_edifi_get_setting('headerStyle');

    $LEFT = '1'; $CENTER = '2'; $RIGHT = '3'; $CENTERCONT = '4';
    $styles = array('LEFT', 'RIGHT', 'CENTER', 'CENTERCONT');

    if (!empty($style) && in_array($style, $styles)) {
        if ($headerStyle == ${$style}) {
            return true;
        } else {
            return false;
        }
    } else {
        $ch = array();
        foreach ($styles as $sty) {
             if ($headerStyle == ${$sty}) {
                $ch[$sty] = true;
            } else {
                $ch[$sty] = false;
            }
        }
      
        return $ch;
    }
}

/**
 * Load the social media icons.
 * @return type
 */
function theme_edifi_social_media() {
    global $CFG;
    for ($i = 1; $i <= 4; $i++) {
        $social['sicon'.$i] = theme_edifi_get_setting('socialicon'.$i);
        $social['surl'.$i] = theme_edifi_get_setting('siconurl'.$i);
    }
    return $social;
}

/**
 * Process the footer logo.
 * @return type|string
 */
function theme_edifi_footer_logo() {
    global $CFG, $PAGE;
    $footerUrl = $PAGE->theme->setting_file_url('footerlogo', 'footerlogo');
    if (!empty($footerUrl)) {
        return $footerUrl;
    }
    return "";
}
/**
 * Display Footer Block Custom Links
 * @param string $menu_name Footer block link name.
 * @return string The Footer links are return.
 */

function theme_edifi_generate_links($menuname = '') {
    global $CFG, $PAGE;
    $htmlstr = '';
    $menustr = theme_edifi_get_setting($menuname);
    $menusettings = explode("\n", $menustr);
    foreach ($menusettings as $menukey => $menuval) {
        $expset = explode("|", $menuval);
        if (!empty($expset) && isset($expset[0]) && isset($expset[1])) {
            list($ltxt, $lurl) = $expset;
            $ltxt = trim($ltxt);
            $ltxt = theme_edifi_lang($ltxt);
            $lurl = trim($lurl);
            if (empty($ltxt)) {
                continue;
            }
            if (empty($lurl)) {
                $lurl = 'javascript:void(0);';
            }
            $pos = strpos($lurl, 'http');
            if ($pos === false) {
                $lurl = new moodle_url($lurl);
            }
            $htmlstr .= '<li><a href="'.$lurl.'">'.$ltxt.'</a></li>'."\n";
        }
    }
    if (!empty($htmlstr))
        return "<ul>".$htmlstr."</ul>";
    else
        return "";
}

/**
 * Description
 * @return type
 */
function theme_edifi_footer_blocks() {
    global $CFG, $PAGE;
    $footer = array();
    $footerArr = ['footerdesc'];
    $key = 1;
    for ($i = 1; $i <= 4; $i++) {
        $footer['status'.$i] = theme_edifi_get_setting('footerbstatus'. $i);
        $title = theme_edifi_get_setting('footerbtitle'. $i);
        $footer['title'.$i] = (!empty($title)) ? theme_edifi_lang($title) : "";
        if ($i == 1) {
            $footernote = theme_edifi_get_setting('footnote', 'format_html');
            $footer['desc'.$i] = theme_edifi_lang($footernote);
        } else {
            $footerdesc = theme_edifi_get_setting('footerdesc'.$i, 'format_html');
            $footer['desc'.$i] = theme_edifi_lang($footerdesc);
        }
       
    }
   
    return $footer;
}

/**
 * Load the preloader html content into theme header.
 * @return type|string
 */
function theme_edifi_get_loader() {
    global $OUTPUT, $PAGE;

    $loaderStatus = theme_edifi_get_setting('preloader_status');

    if ($loaderStatus == '1') {

        $loadercolor = theme_edifi_get_setting('preloaderbg_color');
        $loadercolor = (isset($loadercolor) && !empty($loadercolor)) ? $loadercolor : "#353535";
        $loaderlogo = theme_edifi_get_logo_url();
        /* $loaderlogo = (isset($loaderlogo) && !empty($loaderlogo)) ? $loaderlogo : $OUTPUT->image_url("home/logo", 'theme');*/

        $loaderimg = $PAGE->theme->setting_file_url('preloader', 'preloader');
       
        $loaderimg = (!empty($loaderimg)) ? $loaderimg : $OUTPUT->image_url('home/loader', 'theme');
        $loader = html_writer::start_tag('div', array('class' => 'theme_loader', 'id' => 'theme_loader', 'style' => 'background-color: '.$loadercolor.';'));

       
        if (!empty($loader)) {
            $loader .= html_writer::empty_tag('img', array('src' => $loaderimg, 'class' => 'loader-img' ));
        } 

        $loader .= html_writer::end_tag('div');
        
    } else {
        $loader = "";
    }

    return $loader;
}

/**
 * Find the footer status.
 * @param type|string $status
 * @return type
 */
function theme_edifi_footer_status($status='') {
    global $CFG, $PAGE;
    $n = 1;
    $status = array();
    for ($i = 1; $i <= 4; $i++) {
        $status[$i] = theme_edifi_footer_content_status($i);
        if ($status[$i]) {
            $n++;
        }
    }

    return $status;
}

/**
 * Find the footer content status.
 * @return type|bool
 */
function theme_edifi_center_footer_status() {
    global $CFG, $PAGE;
    $address = theme_edifi_lang(theme_edifi_get_setting('address', 'format_html'));
    $emailid = theme_edifi_lang(theme_edifi_get_setting('emailid'));
    $phoneno = theme_edifi_lang(theme_edifi_get_setting('phoneno'));
    $footerLogo = theme_edifi_footer_logo();
    if (empty($footerLogo) && empty($address) && empty($emailid) && empty($phoneno) ) {
        return false;
    } else {
        return true;
    }
}

/**
 * Define footer blocks class based on it's count.
 * @param type|string $status
 * @param type|bool $centerFooter
 * @return type|string
 */
function theme_edifi_footer_class($status='', $centerFooter = true) {
    global $CFG, $PAGE;
    $n = 1;
    
    for ($i = 1; $i <= 4; $i++) {
        $status[$i] = theme_edifi_footer_content_status($i);
        if ($status[$i] && !empty($status[$i])) {
            $n++;
        }
    }

    $footer_status = theme_edifi_footer_status('status');
    $arrayfilter = array_filter($footer_status, function($value) { return $value != false;});
    $count = count($arrayfilter);
    if ($centerFooter == false) {
        $count--;
        $mClass = "left-content";
    } else {
        $mClass = "";
    }
    $class = array();
    switch($count) {
        case 4:
            $class = array( 1 => 'col-lg-2 ', 2 => 'col-lg-2 ', 3 => 'col-lg-2 ', 4 => 'col-lg-2 ', 'cen' => 'col-lg-4 text-center', 'lblock' => false, 'blockclass' => 'footer-center-block '.$mClass );
            break;
        case 3:
            $class = array( 1 => 'col-lg-3 ', 2 => 'col-lg-3 ', 3 => 'col-lg-3 ', 4 => 'col-lg-3 ', 'cen' => 'col-lg-3 ', 'lblock' => true, 'blockclass' => 'footer-left-block '.$mClass );
            break;
        case 2:
            $class = array( 1 => 'col-lg-4', 2 => 'col-lg-4', 3 => 'col-lg-4', 4 => 'col-lg-4', 'cen' => 'col-lg-4', 'lblock' => false, 'blockclass' => 'footer-center-block '. $mClass );
            break;
        case 1:
            $class = array( 1 => 'col-lg-6', 2 => 'col-lg-6 ', 3 => 'col-lg-6 ', 4 => 'col-lg-6 ', 'cen' => 'col-lg-6 ', 'lblock' => true, 'blockclass' => 'footer-left-block '. $mClass );
            break;
        default:
            $class = array( 1 => 'col-lg-12', 2 => 'col-lg-12 ', 3 => 'col-lg-12 ', 4 => 'col-lg-12 ', 'cen' => 'col-lg-12 ', 'lblock' => true, 'blockclass' => 'footer-center-block '. $mClass );
        break;

    }
    $centerStatus = theme_edifi_center_footer_status();
    if ( $centerStatus != false) {
        if ($count == 2) {
            if (empty($status[3]) && empty($status[4])) {
                $class[1] .= ' pull-left text-lg-right';
                $class[2] .= ' pull-right text-lg-left order-lg-1';
            } else if (empty($status[1]) && empty($status[2])) {
                $class[3] .= ' pull-lg-4 text-lg-right order-lg-0';
                $class['cen'] .= ' push-lg-4 text-lg-center order-lg-1';
                $class[4] .= ' text-lg-left order-lg-2';
            } else {
                $class[1] .= ' text-lg-right';
                $class[2] .= ' text-lg-right';
                $class[3] .= ' text-lg-left';
                $class[4] .= ' text-lg-left';
            }
        } else if ($count == 4) {
            $class[1] .= ' text-lg-right';
            $class[2] .= ' text-lg-right';
            $class[3] .= ' text-lg-left';
            $class[4] .= ' text-lg-left';
        } else {
            $align = ($count == 0) ? 'center' : 'left';
            for ($i = 1; $i <= 4; $i++)
                $class[$i] .= ' text-lg-'.$align;
                $class['cen'] .= ' text-lg-'.$align;
        }
    } else {
         $align = ($count == 0) ? 'center' : 'left';
            for ($i = 1; $i <= 4; $i++)
                $class[$i] .= ' text-lg-'.$align;
            $class['cen'] .= ' text-lg-'.$align;
    }
    $footer_status = theme_edifi_footer_status('status');
    if (!empty($footer_status)) {
        foreach ($footer_status as $key => $fs) {
            if ( empty($fs) ) {
                $class[$key] = false;
            }
        }
    }
    return $class;
}

/**
 * Find the available footer blocks status is enabled or disabled.
 * @param type|string $i
 * @return type
 */
function theme_edifi_footer_content_status($i = '') {
    $status = theme_edifi_get_setting('footerbstatus'.$i);
    if ($status) {
        $title = theme_edifi_get_setting('footerbtitle'.$i);
        // $desc = theme_edifi_get_setting('footerdesc'. $i);

        if ($i == 1) {
            $desc = theme_edifi_get_setting('footnote');
        } else {
            $desc = theme_edifi_get_setting('footerdesc'.$i);
        }

        if (!empty($title) || !empty($desc)) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

/**
 * Load the lang menu
 * @return string
 */
function theme_edifi_get_lang() {
    global $PAGE;
    $rend = $PAGE->get_renderer('core');
    return $rend->theme_edifi_lang_menu();
}

/**
 * Get the login background image url from settings and add the url into scss
 * @return string
 */


/**
 * Get the details about the selected course.
 * @param type $args
 * @return type
 */
function theme_edifi_courseInfobox($args) {
    global $DB, $PAGE;
    $rend = $PAGE->get_renderer('course');
    if ( $course = $DB->get_record("course", array("id" => $args['elementid']))) {
        return $rend->course_info_box($course);
    }
}
if (isset($_POST['function']) && isset($_POST['elementid'])) {
    echo theme_edifi_courseInfobox(array('elementid' => $_POST['elementid']));
}


/**
 * Cut the Course content.
 *
 * @param $str
 * @param $n
 * @param $end_char
 * @return string
 */
function theme_edifi_course_trim_char($str, $n = 500, $endchar = '&#8230;') {
    if (strlen($str) < $n) {
        return $str;
    }

    $str = preg_replace("/\s+/", ' ', str_replace(array("\r\n", "\r", "\n"), ' ', $str));
    if (strlen($str) <= $n) {
        return $str;
    }

    $out = "";
    $small = substr($str, 0, $n);
    $out = $small.$endchar;
    return $out;
}


/**
 * Remove the html special tags from course content.
 * This function used in course home page.
 *
 * @param string $text
 * @return string
 */
function theme_edifi_strip_html_tags( $text ) {
    $text = preg_replace(
        array(
            // Remove invisible content.
            '@<head[^>]*?>.*?</head>@siu',
            '@<style[^>]*?>.*?</style>@siu',
            '@<script[^>]*?.*?</script>@siu',
            '@<object[^>]*?.*?</object>@siu',
            '@<embed[^>]*?.*?</embed>@siu',
            '@<applet[^>]*?.*?</applet>@siu',
            '@<noframes[^>]*?.*?</noframes>@siu',
            '@<noscript[^>]*?.*?</noscript>@siu',
            '@<noembed[^>]*?.*?</noembed>@siu',
            // Add line breaks before and after blocks.
            '@</?((address)|(blockquote)|(center)|(del))@iu',
            '@</?((div)|(h[1-9])|(ins)|(isindex)|(p)|(pre))@iu',
            '@</?((dir)|(dl)|(dt)|(dd)|(li)|(menu)|(ol)|(ul))@iu',
            '@</?((table)|(th)|(td)|(caption))@iu',
            '@</?((form)|(button)|(fieldset)|(legend)|(input))@iu',
            '@</?((label)|(select)|(optgroup)|(option)|(textarea))@iu',
            '@</?((frameset)|(frame)|(iframe))@iu',
        ),
        array(
            ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ', ' ',
            "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0", "\n\$0",
            "\n\$0", "\n\$0",
        ),
        $text
    );
    return strip_tags( $text );
}

function theme_edifi_output_fragment_get_category_courses($args) {
    global $PAGE;

    $categoryid = $args['categoryid'];
    $parentid = $args['parentid'];
    if (!empty($categoryid)) {
        $renderers = $PAGE->get_renderer('core','course');
        $output = $renderers->get_category_courses($categoryid,$parentid);
    }
    return $output;

}

function theme_edifi_center_menu_split($nodes) {
    $centerMenu = [];
    if (!empty($nodes)) {
        $count = count($nodes);
        $splitLevel = ceil($count / 2);
        $i = 1;
        foreach ($nodes as $node) {
            if ($splitLevel >= $i) {
                $centerMenu[1][] = $node;
            } else {
                $centerMenu[2][] = $node;
            }
            $i++;
        }
    }
    return $centerMenu;
}