<?php
/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot . "/course/renderer.php");

class theme_edifi_core_course_renderer extends core_course_renderer {
    protected function coursecat_coursebox(coursecat_helper $chelper, $course, $additionalclasses = '') {
        global $CFG;
        if (!isset($this->strings->summary)) {
            $this->strings->summary = get_string('summary');
        }
        if ($chelper->get_show_courses() <= self::COURSECAT_SHOW_COURSES_COUNT) {
            return '';
        }
        if ($course instanceof stdClass) {
            $course = new core_course_list_element($course);
        }
        $content = '';
        $classes = trim('panel panel-default coursebox clearfix '. $additionalclasses);
        if ($chelper->get_show_courses() < self::COURSECAT_SHOW_COURSES_EXPANDED) {
            $classes .= ' collapsed';
        }

        // .coursebox.
        $content .= html_writer::start_tag('div', [
            'class' => $classes,
            'data-courseid' => $course->id,
            'data-type' => self::COURSECAT_TYPE_COURSE,
        ]);

        $content .= html_writer::start_tag('div', ['class' => 'panel-heading info']);

        // course name.

        $fa_arrow = "fa-arrow-circle-right";

        if ( right_to_left() ) {
            $fa_arrow = "fa-arrow-circle-left";
        } else {
            $fa_arrow = "fa-arrow-circle-right";
        }

        $coursename = $chelper->get_course_formatted_name($course);

        $courseurl = new moodle_url('/course/view.php', ['id' => $course->id]);
        $courselink_class = $course->visible ? '' : 'dimmed';
        $coursenamelink = '<a href="'.$courseurl.'" class="'.$courselink_class.'">'.$coursename.'</a>';

        $content .= html_writer::tag('span', $coursenamelink, ['class' => 'coursename']);
        // If we display course in collapsed form but the course has summary or course contacts, display the link to the info page.
        $content .= html_writer::start_tag('span', ['class' => 'moreinfo']);
        if ($chelper->get_show_courses() < self::COURSECAT_SHOW_COURSES_EXPANDED) {
            if ($course->has_summary() || $course->has_course_contacts() || $course->has_course_overviewfiles()) {
                $url = new moodle_url('/course/info.php', ['id' => $course->id]);
                $image = html_writer::empty_tag('img', ['src' => $this->output->image_url('ic-info', 'theme'),
                    'alt' => $this->strings->summary]);
                $content .= html_writer::link($url, $image, ['title' => $this->strings->summary]);
                // Make sure JS file to expand course content is included.
                $this->coursecat_include_js();
            }
        }
        $content .= html_writer::end_tag('span'); // .moreinfo

        // print enrolmenticons.
        if ($icons = enrol_get_course_info_icons($course)) {
            $content .= html_writer::start_tag('div', ['class' => 'enrolmenticons']);
            foreach ($icons as $pix_icon) {
                $content .= $this->render($pix_icon);
            }
            $content .= html_writer::end_tag('div'); // .enrolmenticons
        }

        $content .= html_writer::end_tag('div'); // .info
        $img = $this->coursecat_coursebox_content($chelper, $course, 'image');
        $imgstatusclass = ($img == false ) ? "course-image-false" : "";

        $content .= html_writer::start_tag('div', ['class' => 'content panel-body '.$imgstatusclass]);
        $content .= $this->coursecat_coursebox_content($chelper, $course);

        if ($chelper->get_show_courses() >= self::COURSECAT_SHOW_COURSES_EXPANDED) {
            $icondirection = 'left';
            if ('ltr' === get_string('thisdirection', 'langconfig')) {
                $icondirection = 'right';
            }
            /*if (is_enrolled(context_course::instance($course->id))) {
                $arrow = html_writer::tag('span', '', array('class' => ' glyphicon glyphicon-arrow-'.$icondirection));
                $visit = html_writer::tag('span', get_string('course') . ' ' . $arrow);
                $visitlink = html_writer::link(new moodle_url('/course/view.php',
                    array('id' => $course->id)), $visit);
                $content .= html_writer::tag('div', $visitlink, array('class' => 'visitlink'));
            }*/
        }
        $content .= html_writer::end_tag('div'); // .content

        $content .= html_writer::end_tag('div'); // .coursebox
        return $content;
    }

    protected function coursecat_coursebox_content(coursecat_helper $chelper, $course, $checkImg = "") {
        global $CFG;
        if ($chelper->get_show_courses() < self::COURSECAT_SHOW_COURSES_EXPANDED) {
            return '';
        }
        if ($course instanceof stdClass) {
            $course = new core_course_list_element($course);
        }
        $content = '';

        // Display course overview files.
        $contentimages = $contentfiles = '';
        foreach ($course->get_course_overviewfiles() as $file) {
            $isimage = $file->is_valid_image();
            $url = file_encode_url("$CFG->wwwroot/pluginfile.php",
                    '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                    $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
            if ($isimage) {
                    $contentimages .= html_writer::start_tag('div', ['class' => 'imagebox ']);

                    $images = html_writer::empty_tag('img', ['src' => $url, 'alt' => 'Course Image '. $course->get_formatted_name(),
                        'class' => 'courseimage ps']);
                    $contentimages .= html_writer::link(new moodle_url('/course/view.php', ['id' => $course->id]), $images);

                    $contentimages .= html_writer::end_tag('div');

            } else {
                $image = $this->output->pix_icon(file_file_icon($file, 24), $file->get_filename(), 'moodle');
                $filename = html_writer::tag('span', $image, ['class' => 'fp-icon']).
                        html_writer::tag('span', $file->get_filename(), ['class' => 'fp-filename']);
                $contentfiles .= html_writer::tag('span',
                        html_writer::link($url, $filename),
                        ['class' => 'coursefile fp-filename-icon']);

            }
        }
        if ($checkImg == "image") {
            return ( $contentimages == "") ? false : true;
        }
        $content .= $contentimages. $contentfiles;

        // Display course summary.
        if ($course->has_summary()) {
            $content .= html_writer::start_tag('div', ['class' => 'summary']);
            $content .= $chelper->get_course_formatted_summary($course,
                    ['overflowdiv' => true, 'noclean' => true, 'para' => false]);
            $content .= html_writer::end_tag('div'); // .summary
        }

        // Display course contacts. See core_course_list_element::get_course_contacts().
        if ($course->has_course_contacts()) {
            $content .= html_writer::start_tag('ul', ['class' => 'teachers']);
            foreach ($course->get_course_contacts() as $userid => $coursecontact) {
                $name = $coursecontact['rolename'].': '.
                        html_writer::link(new moodle_url('/user/view.php',
                                ['id' => $userid, 'course' => SITEID]),
                            $coursecontact['username']);
                $content .= html_writer::tag('li', $name);
            }
            $content .= html_writer::end_tag('ul'); // .teachers
        }

        // Display course category if necessary (for example in search results).
        if ($chelper->get_show_courses() == self::COURSECAT_SHOW_COURSES_EXPANDED_WITH_CAT) {
            if ($cat = core_course_category::get($course->category, IGNORE_MISSING)) {
                $content .= html_writer::start_tag('div', ['class' => 'coursecat']);
                $content .= get_string('category').': '.
                        html_writer::link(new moodle_url('/course/index.php', ['categoryid' => $cat->id]),
                                $cat->get_formatted_name(), ['class' => $cat->visible ? '' : 'dimmed']);
                $content .= html_writer::end_tag('div'); // .coursecat
            }
        }
        return $content;
    }

    public function course_search_form($value = '', $format = 'plain') {
        static $count = 0;
        global $PAGE;
        $formid = 'coursesearch';
        if ((++$count) > 1) {
            $formid .= $count;
        }
        $inputid = 'coursesearchbox';
        $inputsize = 30;

        if ($format === 'navbar') {
            $formid = 'coursesearchnavbar';
            $inputid = 'navsearchbox';
        }
        // Customize the search courses form
        $strsearchcourses = get_string("searchcourses");
        $search_title = theme_edifi_lang(theme_edifi_get_setting('csearch_title'));

        $searchtitle = (!empty($search_title)) ? $search_title : $strsearchcourses;
        $searchdesc = theme_edifi_lang(theme_edifi_get_setting('csearch_desc'));
        $searchurl = new moodle_url('/course/search.php');

        $form = ['id' => $formid, 'action' => $searchurl, 'method' => 'get', 'class' => "form-inline text-right", 'role' => 'form'];
        $output = '';
        if ($PAGE->pagelayout == 'frontpage') {

            $output = html_writer::start_tag('div', ['class' => 'search-form  title']);
            $output .= html_writer::tag('h2', $searchtitle, ['class' => 'title-headings']);
            $output .= html_writer::tag('p', $searchdesc);
            $output .= html_writer::end_tag('div');
        }
        $output .= html_writer::start_tag('form', $form);
        $output .= html_writer::start_div('input-group');
        $output .= html_writer::tag('label', $strsearchcourses, ['for' => $inputid, 'class' => 'sr-only']);
        $search = ['type' => 'text', 'id' => $inputid, 'size' => $inputsize, 'name' => 'search', 'class' => 'form-control', 'value' => s($value), 'placeholder' => $strsearchcourses];
        $output .= html_writer::empty_tag('input', $search);
        $output .= html_writer::start_span('input-group-btn');
                                $output .= '<button class="btn btn-default" type="submit"><i class="fa fa-search"></i></button>';
        $output .= html_writer::end_span();
        $output .= html_writer::end_div(); // Close form-group.
        $output .= html_writer::end_tag('form');
        
        return $output;
    }

    public function course_insights_home($f = 0) {
        $courses = 0;
        $teachers = 0;
        $students = 0;
        $acourses = [];
        $astu = [];
        $atea = [];
        // Get all courses.
        if ($ccc = get_courses('all', 'c.sortorder ASC', 'c.id,c.shortname,c.visible')) {
            foreach ($ccc as $cc) {
                if ($cc->visible == "0" || $cc->id == "1") {
                    continue;
                }
                $courses++;

                $context = context_course::instance($cc->id);

                // count no of teachers.
                $no_teachers = count_role_users(3, $context);
                $teachers = $teachers + $no_teachers;
                // count no of students.
                $no_students = count_role_users(5, $context);
                $students = $students + $no_students;
                $acourses[] = ['cid' => $cc->id, 'students' => $no_students, 'teachers' => $no_teachers];
                $astu[] = $no_students;
                $atea[] = $no_teachers;
            }
        }
        if ($f == "1") {
            array_multisort($astu, SORT_DESC, $atea, SORT_DESC, $acourses);
            return $acourses;
        }
        return compact('courses', 'teachers', 'students');
    }

    public function frontpage_my_courses() {
        global $USER, $CFG, $DB;
        $slickHeader = '';
        if (!isloggedin() || isguestuser()) {
            return '';
        }
        $output = '';

        if (!empty($CFG->navsortmycoursessort)) {
            // sort courses the same as in navigation menu.
            $sortorder = 'visible DESC,'. $CFG->navsortmycoursessort.' ASC';
        } else {
            $sortorder = 'visible DESC,sortorder ASC';
        }
        $courses  = enrol_get_my_courses('summary, summaryformat', $sortorder);
        $rhosts   = [];
        $rcourses = [];
        if (!empty($CFG->mnet_dispatcher_mode) && $CFG->mnet_dispatcher_mode === 'strict') {
            $rcourses = get_my_remotecourses($USER->id);
            $rhosts   = get_my_remotehosts();
        }
        if (!empty($courses) || !empty($rcourses) || !empty($rhosts)) {

            $mycourse_status = theme_edifi_get_setting('mycourse_displaytype');
            if ($mycourse_status == 0) {
                return parent::frontpage_my_courses();
            }

            $chelper = new coursecat_helper();
            if (count($courses) > $CFG->frontpagecourselimit) {
                // There are more enrolled courses than we can display, display link to 'My courses'.
                $totalcount = count($courses);
                $courses = array_slice($courses, 0, $CFG->frontpagecourselimit, true);
                $chelper->set_courses_display_options([
                        'viewmoreurl' => new moodle_url('/my/'),
                        'viewmoretext' => new lang_string('mycourses'),
                    ]);
            } else {
                // All enrolled courses are displayed, display link to 'All courses' if there are more courses in system.
                $chelper->set_courses_display_options([
                        'viewmoreurl' => new moodle_url('/course/index.php'),
                        'viewmoretext' => new lang_string('fulllistofcourses'),
                    ]);
                $totalcount = $DB->count_records('course') - 1;
            }

            $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED)->
                    set_attributes(['class' => 'frontpage-course-list-enrolled']);
            // $output .= $this->coursecat_courses($chelper, $courses, $totalcount);
            if ($totalcount === null) {
                $totalcount = count($courses);
            }
            if (!$totalcount) {
                 return '';
            }

            // display list of courses.
            $slickHeader = html_writer::start_tag('div', ['class' => 'mycourse-control slick-page-nav']);
            if ($totalcount >= 5) {
                $slickHeader .= html_writer::start_tag('button', ['class' => 'slick-prev']);
                $slickHeader .= html_writer::tag('i', '', ['class' => 'fa fa-caret-left']);
                $slickHeader .= html_writer::end_tag('button');
                $slickHeader .= html_writer::start_tag('button', ['class' => 'slick-next']);
                $slickHeader .= html_writer::tag('i', '', ['class' => 'fa fa-caret-right']);
                $slickHeader .= html_writer::end_tag('button');
            }
            $slickHeader .= html_writer::end_tag('div');

            $attributes = $chelper->get_and_erase_attributes('courses slick_myenrolled_course col-md-12');

            $output  = html_writer::start_tag('div',['class' => 'row']);
            $output .= html_writer::start_tag('div', $attributes);

            $coursesChunk = array_chunk($courses, 3);
            // print_object($coursesChunk);
            $coursecount = 0;
            foreach ($coursesChunk as $key => $courses) {
              
                foreach ($courses as $course) {
                    $coursecount ++;
                    $classes = ($coursecount % 2) ? 'odd' : 'even';
                    if ($coursecount == 1) {
                        $classes .= ' first';
                    }   
                    if ($coursecount >= count($courses)) {
                        $classes .= ' last';
                    }
                    $output .= $this->coursecat_coursebox1($chelper, $course, $classes);
                }
                
            }
        }
        $output .= html_writer::end_tag('div');
        $output .= html_writer::end_tag('div');

        $coursehtml = $slickHeader.$output;

        if (empty($coursesChunk)) {

            $coursehtml = "<div id='mycourses' class='mycourse-control'><style> #frontpage-course-list.frontpage-mycourses { display:none;} </style></div>";
        }
        return $coursehtml;
    }
    /**
     * Returns HTML to print list of available courses for the frontpage
     *
     * @return string
     */
    public function frontpage_available_courses() {
        global $CFG;
        $availableCourses = theme_edifi_get_setting('availablecourse_displaytype');
        if ($availableCourses == 0) {
            return parent::frontpage_available_courses();
        }

        $chelper = new coursecat_helper();
        $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED)->
                set_courses_display_options([
                    'recursive' => true,
                    'limit' => $CFG->frontpagecourselimit,
                    'viewmoreurl' => new moodle_url('/course/index.php'),
                    'viewmoretext' => new lang_string('fulllistofcourses')]);

        $chelper->set_attributes(['class' => 'frontpage-course-list-all available-courses']);
        $courses = core_course_category::get(0)->get_courses($chelper->get_courses_display_options());
        $totalcount = core_course_category::get(0)->get_courses_count($chelper->get_courses_display_options());
        if (!$totalcount && !$this->page->user_is_editing() && has_capability('moodle/course:create', context_system::instance())) {
            // Print link to create a new course, for the 1st available category.
            return $this->add_new_course_button();
        }
        if ($totalcount === null) {
            $totalcount = count($courses);
        }
        if (!$totalcount) {
            return '';
        }
        $slickHeader = html_writer::start_tag('div', ['class' => 'available-courses-control slick-page-nav']);
        if ($totalcount > 4) {
            $slickHeader .= html_writer::start_tag('button', ['class' => 'slick-prev']);
            $slickHeader .= html_writer::tag('i', '', ['class' => 'fa fa-caret-left']);
            $slickHeader .= html_writer::end_tag('button');
            $slickHeader .= html_writer::start_tag('button', ['class' => 'slick-next']);
            $slickHeader .= html_writer::tag('i', '', ['class' => 'fa fa-caret-right']);
            $slickHeader .= html_writer::end_tag('button');
        }
        $slickHeader .= html_writer::end_tag('div');
        // display list of courses.
        $attributes = $chelper->get_and_erase_attributes('courses ');
        $content = html_writer::start_tag('div', $attributes);
        $content .= html_writer::start_tag('div',['class' => 'row']);
        $content .= html_writer::start_tag('div', ['class' => 'slick_available_course col-md-12']);

        $coursesChunk = array_chunk($courses, 3);
        $coursecount = 0;
        foreach ($coursesChunk as $key => $courses) {

            foreach ($courses as $course) {
                $coursecount ++;
                $classes = ($coursecount % 2) ? 'odd' : 'even';
                $classes = '';
                if ($coursecount == 1) {
                    $classes .= ' first';
                }
                if ($coursecount >= count($courses)) {
                    $classes .= ' last';
                }
                $content .= $this->coursecat_coursebox1($chelper, $course, $classes);
            }
           
        }
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div'); // .courses
        $content .= html_writer::end_tag('div');
        $blockcontent = $slickHeader.$content;
     
        return $blockcontent;
        // return $this->coursecat_courses2($chelper, $courses, $totalcount);
    }

    /**
     * Course category helper coursebox1.
     * @param coursecat_helper $chelper
     * @param type $course
     * @param type|string $additionalclasses
     * @return type
     */
    public function coursecat_coursebox1(coursecat_helper $chelper, $course, $additionalclasses = '') {
        global $CFG, $OUTPUT;

        if ($chelper->get_show_courses() <= self::COURSECAT_SHOW_COURSES_COUNT) {
            return '';
        }
        if ($course instanceof stdClass) {
            $course = new core_course_list_element($course);
        }
        $content = '';
        $classes = trim('col-md-4 '. $additionalclasses);
        if ($chelper->get_show_courses() >= self::COURSECAT_SHOW_COURSES_EXPANDED) {
            $nametag = 'h3';
        } else {
            $classes .= ' collapsed';
            $nametag = 'div';
        }

        // .coursebox
        $content .= html_writer::start_tag('div', [
            'class' => $classes,
            'data-courseid' => $course->id,
            'data-type' => self::COURSECAT_TYPE_COURSE,
        ]);
        $content .= html_writer::start_tag('div', ['class' => 'coursebox']);
        $context = context_course::instance($course->id);
        $no_students = count_role_users(5, $context);
        if ($no_students == 1) {
            $enroll_student = $no_students." ".get_string('student', 'theme_edifi');
        } else {
            $enroll_student = $no_students." ".get_string("students", 'theme_edifi');
        }

        $content .= html_writer::start_tag('div', ['class' => 'content']);
        $courseUrl = new moodle_url('/course/view.php', ['id' => $course->id]);

        // Display course overview files.
        $contentimages = $contentfiles = $isimage = '';
        foreach ($course->get_course_overviewfiles() as $file) {
            $isimage = $file->is_valid_image();
            $url = file_encode_url("$CFG->wwwroot/pluginfile.php",
                    '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                    $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);
        }
        if (!$isimage) {
            $url = $OUTPUT->image_url('no-image', 'theme');
        }
        $imagehref = html_writer::link(new moodle_url('/course/view.php', ['id' => $course->id]), html_writer::empty_tag('img', ['src' => $url]) );

        $contentimages .= html_writer::tag('div', $imagehref, ['class' => 'courseimage']);

        $content .= $contentimages. $contentfiles;
        $content .= html_writer::start_tag('div', ['class' => 'info']);

        // Course name.
        $coursename = $chelper->get_course_formatted_name($course);
        $coursenamelink = html_writer::link(new moodle_url('/course/view.php', ['id' => $course->id]),
        $coursename, ['class' => $course->visible ? '' : 'dimmed']);
        $content .= html_writer::tag($nametag, $coursenamelink, ['class' => 'coursename']);
        $content .= html_writer::end_tag('div'); // .info
        if ($course->has_summary()) {
            $content .= html_writer::start_tag('div', ['class' => 'summary']);
            $summaryCon = $course->summary;
            $summaryCon = theme_edifi_strip_html_tags($summaryCon);
            $summaryCon = theme_edifi_course_trim_char($summaryCon,120); 
            $content .= $summaryCon;
            $content .= html_writer::end_tag('div'); // .summary
        }

        $content .= html_writer::start_tag('div', ['class' => 'read-btn']);
        $content .= html_writer::tag('a', get_string('readmore', 'theme_edifi' ), ['class' => 'btn btn-primary', 'href' => $courseUrl]);
        $content .= html_writer::end_tag('div');

         $content .= html_writer::start_tag('div', ['class' => 'no_students']);
        $content .= html_writer::start_tag('p');
        $content .= html_writer::tag('i', '', ['class' => 'fa fa-users'] );
        $content .= html_writer::tag('span', $enroll_student)." ";
        $content .= html_writer::tag('em', get_string('enrolled', 'theme_edifi'));
        $content .= html_writer::end_tag('p'); // P.
        $content .= html_writer::end_tag('div'); // .no_students.
        $content .= html_writer::end_tag('div'); // .content
        $content .= html_writer::end_tag('div'); // .coursebox
        $content .= html_writer::end_tag('div'); // .coursebox
        return $content;
    }

    function frontpage_categories_list() {
        global $PAGE;
        $displayOption = $PAGE->theme->settings->categories_displaytype;
        if ($displayOption == '0') {
            return parent::frontpage_categories_list();
        } else  {
            return $this->list_categories();
        }
    }

    public function list_categories() {
        global $CFG, $PAGE, $OUTPUT;
        $content = '';
        $i = '0';
        $displayOption = 1; // $PAGE->theme->settings->categories_displaytype;
        $url = "";
        $rowcount = theme_edifi_get_setting('categoryrow');
        // require_once($CFG->libdir . '/coursecatlib.php');
        $rcoursecats = core_course_category::make_categories_list('', '', 1);
        if (!empty($rcoursecats)) {
            foreach ($rcoursecats as $key => $cats) {
                $courseArr = $this->edifi_get_db_record($key);
                if (!empty($courseArr)) {
                    $catesData[$key] = $courseArr;
                }
            }
            // print_object($rcoursecats);

            $content .= html_writer::start_tag('div', ['class' => 'frontpage-categories']);
            $cateCount = (int) $rowcount * 3;
            $catesData = array_slice($catesData, 0, $cateCount);
            $catsChunk = array_chunk($catesData, 3);
            foreach ($catsChunk as $catesArr) {
                $content .= html_writer::start_tag('div', ['class' => 'row']);

                foreach ($catesArr as $key => $data) {

                    if (!empty($data)) {
                        // echo $rcoursecats->id;
                        $url = new moodle_url('course/index.php', ['categoryid' => $data->id]);
                        $imgsrc = $PAGE->theme->setting_file_url('categoryimg'.$data->id, 'categoryimg'.$data->id);
                        if (empty($imgsrc)) {
                            $imgsrc = $OUTPUT->image_url('no-image', 'theme');
                        }
                        $readmore = get_string ('readmore', 'theme_edifi');
                        $content .= html_writer::start_tag('div', ['class' => 'col-md-4']);
                        $content .= html_writer::start_tag('div', ['class' => 'category loaded']);
                        $content .= html_writer::start_tag('div', ['class' => 'info']);
                        $content .= html_writer::start_tag('div', ['class' => 'category-img']);
                        $content .= html_writer::start_tag('a', ['href' => $url]);
                        $content .= html_writer::empty_tag('img', ['src' => $imgsrc, 'alt' => $data->name ]);
                        $content .= html_writer::end_tag('a');
                        $content .= html_writer::end_tag('div');

                        $content .= html_writer::start_tag('h3', ['class' => 'categoryname']);
                        $content .= html_writer::link($url, format_string($data->name));
                        $content .= html_writer::start_tag('span', ['class' => 'numberofcourse', 'title' => 'Number of courses']);
                        $content .= html_writer::end_tag('span');
                        $content .= html_writer::end_tag('h3');
                        $content .= html_writer::end_tag('div');

                        $content .= html_writer::start_tag('div', ['class' => 'content']);
                        $summary = ($data->description);
                        $summary = ($summary);
                        $content .= $summary;
                        $content .= html_writer::end_tag('div');

                        $content .= html_writer::start_tag('div', ['class' => 'read-more']);
                        $content .= html_writer::link($url, $readmore );
                        $content .= html_writer::end_tag('div');
                        $content .= html_writer::end_tag('div');
                        $content .= html_writer::end_tag('div');
                    }
                }
                $content .= html_writer::end_tag('div');
            }
            $view = get_string ('view');
            $content .= html_writer::start_tag('div', ['class' => 'category-button']);
            $content .= html_writer::tag('a', $view, ['class' => ' btn btn-primary', 'href' => new moodle_url('course/index.php') ]);
            $content .= html_writer::end_tag('div');
            $content .= html_writer::tag('div', '', ['class' => 'clearfix']);
            $content .= html_writer::end_tag('div');
        }
        return $content;
    }

    public function edifi_get_db_record($cat_id) {
        global $DB;
        if ($record = $DB->get_record('course_categories', ['id' => $cat_id, 'parent' => '0', 'visible' => '1'])) {
            if(!empty($record))
                return $record;
            else
                return "";
        }
        return "";
    }

    public function frontpage_combo_list($custompage='') {
        global $CFG;

         $comboListboxType = theme_edifi_get_setting('comboListboxType');
        if ($comboListboxType == 0 && $custompage == '') {
            return parent::frontpage_combo_list();
        }
        $chelper = new coursecat_helper();
        $chelper->set_subcat_depth(0)->
            set_categories_display_options([
                'limit' => $CFG->coursesperpage,
                'viewmoreurl' => new moodle_url('/course/index.php',
                        ['browse' => 'categories', 'page' => 1]),
            ])->
            set_courses_display_options([
                'limit' => $CFG->coursesperpage,
                'viewmoreurl' => new moodle_url('/course/index.php',
                        ['browse' => 'courses', 'page' => 1]),
            ])->
            set_attributes(['class' => 'frontpage-category-combo']);

           // $categorycontent = $this->edifi_coursecat_category_content($chelper, core_course_category::get(0), 1, $custompage);

            $categorycontent = $this->edifi_frontpacombolist($chelper,core_course_category::get(0),false);
            
        if (empty($categorycontent)) {
            return '';
        }
        
        return $categorycontent;
    }

/*    public function edifi_coursecat_category_content(coursecat_helper $chelper, $coursecat, $depth, $custompage='') {
        $parentCategory = $coursecat->get_children($chelper->get_categories_display_options());
        $maincontent = html_writer::start_tag('div', array('class' => 'course-block'));
        $maincontent .= html_writer::start_tag('div', array('class' => 'course-categories-block'));
        $all = get_string ('all');
        if ($custompage == '') {
            $maincontent .= html_writer::start_tag('ul', array('class' => 'nav nav-tabs simplefilter', 'role' => 'tab-list'));

            $maincontent .= html_writer::start_tag('li', array('class' => 'nav-item', 'data-filter' => "all"));
            $maincontent .= html_writer::link("javascript:void(0)", $all, array('class' => "nav-link active", "data-toggle" => "tab", "href" => "#home", "role" => "tab"));
            $maincontent .= html_writer::end_tag('li');
            foreach ($parentCategory as $cateName) {

                $filter = $cateName->id;
                $name = $cateName->get_formatted_name();
                $maincontent .= html_writer::start_tag('li', array('class' => 'nav-item', 'data-filter' => $filter));
                $maincontent .= html_writer::link("javascript:void(0)", $name, array('class' => "nav-link wave-effect wave-light responsive-video"));
                $maincontent .= html_writer::end_tag('li');
            }
            $maincontent .= html_writer::end_tag('ul');
            $maincontent .= html_writer::start_tag('div', array('class' => 'form-group'));
            $maincontent .= html_writer::start_tag('div', array('class' => 'filter-block', 'style' => 'width:100%;'));

            $maincontent .= html_writer::end_tag('div');
            $maincontent .= $this->combo_dropdown($chelper, $parentCategory, $custompage);
            $maincontent .= html_writer::end_tag('div');
        } else {
            $maincontent .= $this->coursepage_title($chelper, $coursecat, $depth, $custompage);
            $maincontent .= $this->course_search_form();
        }
        $maincontent .= $this->combo_get_courses($chelper, $parentCategory, $custompage);
        $maincontent .= html_writer::end_tag('div');
        $maincontent .= html_writer::end_tag('div');
        return $maincontent;
    }*/
 /*   public function  categories_list(coursecat_helper $chelper, $custompage = '') {
        global $DB, $CFG;
        $categories = core_course_category::make_categories_list();
        if (empty($custompage)) {
            $depth = 0; // $CFG->maxcategorydepth;
            foreach ($categories as $key => $cates) {

                if (!empty($depth) && $depth != 0) {
                    if (!$DB->record_exists_sql("SELECT * FROM {course_categories} WHERE depth <= $depth AND id=$key")) {
                        unset($categories[$key]);
                    }
                }
            }
        }
        $content = $filter_id = '';
        foreach ($categories as $subcategory => $value) {
            $courses = core_course_category::get($subcategory)->get_courses($chelper->get_courses_display_options());
            $result = $DB->get_record('course_categories', array('id' => $subcategory));
            if (isset($result->path) ) {
                $explode = array_filter(explode('/', $result->path));
                $implode = implode(', ', $explode);

                $filter_id = $implode; // str_replace('/', ',', $result->path);
            }
            foreach ($courses as $course) {

                $content .= \theme_edifi\extra_blocks::combo_coursebox($course, $filter_id);
            }
        }
        return $content;
    }*/
  /*  public function combo_get_courses(coursecat_helper $chelper, $category=array(), $custompage='') {
        $content = '';
        $content .= html_writer::start_tag('div', array('class' => 'card-block'));
        $content .= html_writer::start_tag('div', array('class' => 'container'));
        $content .= html_writer::start_tag('div', array('class' => 'row filtr-container'));
        $i = $start = $end = 0;
        $content .= $this->categories_list($chelper, $custompage);

        $content .= html_writer::end_tag('div'); // .container.
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div'); // .container.
        return $content;
    }*/

    public function edifi_frontpacombolist(coursecat_helper $chelper, $coursecat, $type = false) {

        global $CFG, $OUTPUT;

        $parentCategory = $coursecat->get_children($chelper->get_categories_display_options());
        $list_all_courses = [];
        $listcourses = [];
        $categorys = [];
        foreach ($parentCategory as $category) {
            $res['name'] = $category->get_formatted_name();
            $res['id'] = $category->id;
            $categorys[] = $res;
            $courses = core_course_category::get($category->id)->get_courses($chelper->get_courses_display_options());
            
            foreach ($courses as $course) {

                $coursename = $course->get_formatted_name();
               // $course->editname = $coursename;
                $list['coursename']  = $coursename;
                $list['courseurl'] = new moodle_url('/course/view.php',['id' => $course->id]);
                $list['courseimage'] = $this->get_courseimage($course);
                array_push($list_all_courses,$course);
                array_push($listcourses,$list);
                
            }
        }
        if ($type == true) {
            return $list_all_courses;
        }
        if (count($listcourses) > 8) {
            $template['show_arrow'] = true;
        } else {
            $template['show_arrow'] = false;
        }
        $template['courses'] = array_chunk($listcourses,8);
        $template['category'] = $categorys;
        $template['subcategorytoggle'] = false;

        return $OUTPUT->render_from_template('theme_edifi/combo_list_item',$template);

    }



    public function combo_dropdown(coursecat_helper $chelper, $category = [], $custompage='') {
        $selection = "";
        $all = get_string('all', 'theme_edifi');
        $subcatestring = get_string('selectsubcategory', 'theme_edifi');
        $ddid = 'dropdownMenu_all';
        $selection .= html_writer::start_tag('div', ['class' => 'dropdown dropdown-subcategory', "data-cateid" => "all"]);
        $selection .= html_writer::tag('button', $subcatestring, ["class" => "btn btn-secondary dropdown-toggle", "type" => "button", "id" => $ddid, "data-bs-toggle" => "dropdown", "aria-haspopup" => "true", "aria-expanded" => "false"]);
        $selection .= html_writer::start_tag('div', ["class" => "dropdown-menu", "aria-labelledby" => $ddid]);
        $selection .= html_writer::link('javascript:void(0)', $all, ["class" => "dropdown-item", 'data-filter' => "all"]);
        $selection .= html_writer::end_tag('div');
        $selection .= html_writer::end_tag('div');

        foreach ($category as $cateName) {
            $catobj = core_course_category::get($cateName->id);
            $haschildren = $catobj->get_children_count();
            $ddid = 'dropdownMenu_' . $cateName->id;
            $selection .= html_writer::start_tag('div', ['class' => 'dropdown dropdown-subcategory', "data-cateid" => $cateName->id]);

            if ($haschildren) {
                $sub_string = get_string('selectsubcategory', 'theme_edifi');
                $cates = $this->combo_subcategory($chelper, $catobj, 1, $custompage);
                $selection .= html_writer::tag('button', $sub_string, ["class" => "btn btn-secondary dropdown-toggle", "type" => "button", "id" => $ddid, "data-bs-toggle" => "dropdown", "aria-haspopup" => "true", "aria-expanded" => "false"]);
                $selection .= html_writer::start_tag('div', ["class" => "dropdown-menu", "aria-labelledby" => $ddid]);
                foreach ($cates as $cate) {
                    $name = core_course_category::get($cate)->name;
                    if (!empty($name)) {
                        $selection .= html_writer::link('javascript:void(0)', $name, ["class" => "dropdown-item", 'data-filter' => $cate]);
                    }
                }
                $selection .= html_writer::end_tag('div');
            } else {
                $sub_string = get_string('none', 'theme_edifi');
                $selection .= html_writer::tag('span', $sub_string, ["class" => "btn btn-secondary disabled"]);
            }
            $selection .= html_writer::end_tag('div');
        }
        return $selection;
    }
    public function combo_subcates($custompage = '') {
        $parent = [];
        $chelper = new coursecat_helper();
        $parentCategory = core_course_category::get(0)->get_children($chelper->get_categories_display_options());
        foreach ($parentCategory as $childs) {
            if(core_course_category::get($childs->id)->get_children_count()) :
                $subcates = $this->combo_subcategory($chelper, core_course_category::get($childs->id), 0, $custompage);
                // print_object($subcates);
                $subCatestr = [];
                foreach ($subcates as $key => $subcate) {
                    // echo $subcate.'<br>';
                    $subCatestr[$subcate] = core_course_category::get($subcate)->name;
                }
                $parent[$childs->id] = $subCatestr;
            endif;
        }
        return json_encode($parent);
    }

    public function combo_subcategory(coursecat_helper $chelper, $coursecat, $depth, $custompage='') {
        $cate = [];
        $subcates = $coursecat->get_children($chelper->get_categories_display_options());
        if (core_course_category::get($coursecat->id)->get_children_count()) {
            $cate[$coursecat->id] = $coursecat->id;
            foreach ($subcates as $key => $subcate) {
                $cate[$key] = $subcate->id;
                if (core_course_category::get($key)->get_children_count()) {
                    $cate[$key.'-sub'] = $this->combo_getsubCategory($chelper, core_course_category::get($key), $depth, [], $custompage);
                }
            }
        } else {
            $cate[$coursecat->id] = $coursecat->id;
        }
        // $cate = $this->combo_getsubCategory($chelper, core_course_category::get(3), $depth);
        // print_r($cate);
        // array_walk_recursive($cate, function($key, $value){ echo $key.'-'.$value;});
        $it = new RecursiveIteratorIterator(new RecursiveArrayIterator($cate));
        $array = [];
        foreach ($it as $key => $v) {
            // echo $key;
            array_push($array, $v);
        }
        // print_object($cate);
        return $array;
    }

    public function combo_getsubCategory(coursecat_helper $chelper, $coursecat, $depth, $array = [], $custompage='') {
        global $CFG;
        $maxdepth = $CFG->maxcategorydepth;
        if (1 ||($maxdepth > $depth) || (!empty($custompage) || $maxdepth == 0)) {

            if ($coursecat->get_children_count()) {
                $subcates = $coursecat->get_children($chelper->get_categories_display_options());
                foreach ($subcates as $key => $subcate) {
                    $array[$key] = $subcate->id;
                    if (core_course_category::get($key)->get_children_count()) {   

                        $array[$key.'-sub'] = $this->combo_getsubCategory($chelper, core_course_category::get($key), $depth + 1, [], $custompage);
                    } else {
                        return $array;
                    }
                }
            } else {
                if (!in_array($coursecat->id, $array))
                    $array[$coursecat->id] = $coursecat->id;
            }
        }

        // print_object($array);

        // } else {
        // if (!in_array($coursecat->id, $array))
        // $array[$coursecat->id] = $coursecat->id;
        // }
        return $array;
    }

    /**
     * Renders HTML to display particular course category - list of it's subcategories and courses
     *
     * Invoked from /course/index.php
     *
     * @param int|stdClass|coursecat $category
     */
    public function course_category($category) {
         global $CFG, $PAGE;
        $courselayout = theme_edifi_get_setting('courselayout');
        if ($courselayout == 'default') {
            return parent::course_category($category);
        }
        $coursecat = core_course_category::get(is_object($category) ? $category->id : $category);
        $site = get_site();
        $output = '';

        if (can_edit_in_category($coursecat->id)) {
            // Add 'Manage' button if user has permissions to edit this category.
            $managebutton = $this->single_button(new moodle_url('/course/management.php',
                ['categoryid' => $coursecat->id]), get_string('managecourses'), 'get');
            $this->page->set_button($managebutton);
        }
        $coursecatid = $coursecat->id;
        if (!$coursecat->id) {
            if (core_course_category::is_simple_site() == 1) {
                // There exists only one category in the system, do not display link to it.
                $coursecat = core_course_category::get_default();
                $strfulllistofcourses = get_string('fulllistofcourses');
                $this->page->set_title("$site->shortname: $strfulllistofcourses");
            } else {
                $strcategories = get_string('categories');
                $this->page->set_title("$site->shortname: $strcategories");
            }
            $coursecatid = 0;
        } else {
            $title = $site->shortname;
            if (core_course_category::is_simple_site() > 1) {
                $title .= ": ". $coursecat->get_formatted_name();
            }
            $this->page->set_title($title);
            // Print the category selector.
        }
        $all = get_string ('all');
        $category_lists = core_course_category::make_categories_list();
        $category_list[0] = $all;
        foreach ($category_lists as $catkey => $catname) {
            $category_list[$catkey] = $catname;
        }
        $output .= html_writer::start_tag('div', ['class' => 'category-block-filter']);
        $output .= html_writer::start_tag('div', ['class' => 'categorypicker']);
        $select = new single_select(new moodle_url('/course/index.php'), 'categoryid',
                $category_list, $coursecatid, null, 'switchcategory');
        $select->set_label(get_string('categories').':');
        $output .= $this->render($select);
        $output .= html_writer::end_tag('div'); // .categorypicker
        // Add course search form.
         $output .= $this->course_search_form();
        $output .= html_writer::end_tag('div'); // .categorypicker

        // Print current category description.
        $chelper = new coursecat_helper();
        if ($description = $chelper->get_category_formatted_description($coursecat)) {
            $output .= $this->box($description, ['class' => 'generalbox info']);
        }

        // Prepare parameters for courses and categories lists in the tree.
        $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_AUTO)
                ->set_attributes(['class' => 'category-browse category-browse-'.$coursecat->id]);
        $coursedisplayoptions = [];
        $catdisplayoptions = [];
        $browse = optional_param('browse', null, PARAM_ALPHA);
        $CFG->coursesperpage = 12;
        $perpage = optional_param('perpage', $CFG->coursesperpage, PARAM_INT);
        $page = optional_param('page', 0, PARAM_INT);
        $baseurl = new moodle_url('/course/index.php');
        if ($coursecat->id) {
            $baseurl->param('categoryid', $coursecat->id);
        }
        if ($perpage != $CFG->coursesperpage) {
            $baseurl->param('perpage', $perpage);
        }
        $coursedisplayoptions['limit'] = $perpage;
        $catdisplayoptions['limit'] = $perpage;
        // $browse = 'courses';
        if ($browse === 'courses' || !$coursecat->has_children()) {
            $coursedisplayoptions['offset'] = $page * $perpage;
            $coursedisplayoptions['paginationurl'] = new moodle_url($baseurl, ['browse' => 'courses']);
            $catdisplayoptions['nodisplay'] = true;
            $catdisplayoptions['viewmoreurl'] = new moodle_url($baseurl, ['browse' => 'categories']);
            $catdisplayoptions['viewmoretext'] = new lang_string('viewallsubcategories');
            $coursedisplayoptions['recursive'] = true;
        } else if ($browse === 'categories' || !$coursecat->has_courses()) {
            $coursedisplayoptions['nodisplay'] = true;
            $catdisplayoptions['offset'] = $page * $perpage;
            $catdisplayoptions['paginationurl'] = new moodle_url($baseurl, ['browse' => 'categories']);
            $coursedisplayoptions['viewmoreurl'] = new moodle_url($baseurl, ['browse' => 'courses']);
            $coursedisplayoptions['viewmoretext'] = new lang_string('viewallcourses');
            $coursedisplayoptions['recursive'] = true;

        } else {
            // we have a category that has both subcategories and courses, display pagination separately.
            $coursedisplayoptions['viewmoreurl'] = new moodle_url($baseurl, ['browse' => 'courses', 'page' => 1]);
            $catdisplayoptions['viewmoreurl'] = new moodle_url($baseurl, ['browse' => 'categories', 'page' => 1]);
            $coursedisplayoptions['recursive'] = true;
        }
        $chelper->set_courses_display_options($coursedisplayoptions)->
        set_categories_display_options($catdisplayoptions);
        $courselists = [];
        $category_list = core_course_category::make_categories_list();
        $category_list[0] = $all;
        $courselist = [];
        $courses = [];
        if (!$coursecat->id) {
            $courses = core_course_category::get(0)->get_courses( $chelper->get_courses_display_options());
            $totalcount = core_course_category::get(0)->get_courses_count(['recursive' => true]);
            $totalcount++;
        } else {
            $courses = core_course_category::get($coursecat->id)->get_courses($chelper->get_courses_display_options());
            $totalcount = core_course_category::get($coursecat->id)->get_courses_count();
        }
        $courselist = $courses;
        // Display course category tree.
        // $output .= $this->coursecat_tree($chelper, $coursecat);
        $paginationurl = new moodle_url($baseurl, ['browse' => 'courses']);
        $chelper->set_courses_display_options([
                'limit' => $perpage,
                'offset' => ((int)$page) * $perpage,
                'paginationurl' => $paginationurl,
            ]);

        $output .= $this->coursecat_courses($chelper, $courselist, $totalcount, "edifirenderer");
        // Add action buttons.
        $output .= $this->container_start('buttons');
        $context = get_category_or_system_context($coursecat->id);
        if (has_capability('moodle/course:create', $context)) {
            // Print link to create a new course, for the 1st available category.
            if ($coursecat->id) {
                $url = new moodle_url('/course/edit.php', ['category' => $coursecat->id, 'returnto' => 'category']);
            } else {
                $url = new moodle_url('/course/edit.php', ['category' => $CFG->defaultrequestcategory, 'returnto' => 'topcat']);
            }
            $output .= $this->single_button($url, get_string('addnewcourse'), 'get');
        }
        if (!empty($CFG->enablecourserequests)) {
            if (\course_request::can_request($context)) {
                $params = [];
                if ($context instanceof \context_coursecat) {
                    $params['category'] = $context->instanceid;
                }
                $output .= $this->single_button(
                    new moodle_url('/course/request.php', $params),
                    get_string('requestcourse'), 'get'
                );
            }
            if (has_capability('moodle/site:approvecourse', $context)) {
                $disabled = !$DB->record_exists('course_request', []);
                $output .= $this->single_button(
                    new moodle_url('/course/pending.php'),
                    get_string('coursespending'), 'get',
                    ['disabled' => $disabled]
                );
            }
        }
        $output .= $this->container_end();
        return $output;
    }

    protected function coursecat_courses(coursecat_helper $chelper, $courses, $totalcount = null, $theme = '') {

        global $CFG, $PAGE;
        if ($totalcount === null) {
            $totalcount = count($courses);
        }
        if (!$totalcount) {
            // Courses count is cached during courses retrieval.
            return '';
        }

        if ($chelper->get_show_courses() == self::COURSECAT_SHOW_COURSES_AUTO) {
            // In 'auto' course display mode we analyse if number of courses is more or less than $CFG->courseswithsummarieslimit
            if ($totalcount <= $CFG->courseswithsummarieslimit) {
                $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED);
            } else {
                $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_COLLAPSED);
            }
        }

        // Prepare content of paging bar if it is needed.
        $paginationurl = $chelper->get_courses_display_option('paginationurl');
        $paginationallowall = $chelper->get_courses_display_option('paginationallowall');
        if ($totalcount > count($courses)) {
            // There are more results that can fit on one page.
            if ($paginationurl) {
                // The option paginationurl was specified, display pagingbar.
                $perpage = $chelper->get_courses_display_option('limit', $CFG->coursesperpage);
                $page = $chelper->get_courses_display_option('offset') / $perpage;
                $pagingbar = $this->paging_bar($totalcount, $page, $perpage,
                        $paginationurl->out(false, ['perpage' => $perpage]));
                if ($paginationallowall) {
                    $pagingbar .= html_writer::tag('div', html_writer::link($paginationurl->out(false, ['perpage' => 'all']),
                            get_string('showall', '', $totalcount)), ['class' => 'paging paging-showall']);
                }
            } else if ($viewmoreurl = $chelper->get_courses_display_option('viewmoreurl')) {
                // The option for 'View more' link was specified, display more link.
                $viewmoretext = $chelper->get_courses_display_option('viewmoretext', new lang_string('viewmore'));
                $morelink = html_writer::tag('div', html_writer::link($viewmoreurl, $viewmoretext),
                        ['class' => 'paging paging-morelink']);
            }
        } else if (($totalcount > $CFG->coursesperpage) && $paginationurl && $paginationallowall) {
            // There are more than one page of results and we are in 'view all' mode, suggest to go back to paginated view mode.
            $pagingbar = html_writer::tag('div', html_writer::link($paginationurl->out(false, ['perpage' => $CFG->coursesperpage]),
                get_string('showperpage', '', $CFG->coursesperpage)), ['class' => 'paging paging-showperpage']);
        }

        // Display list of courses.
        $attributes = $chelper->get_and_erase_attributes('courses');
        $content = html_writer::start_tag('div', $attributes);

        if (!empty($pagingbar)) {
            
            $content .= $pagingbar;
        }

        $coursecount = 0;
        $content2 = '';
        foreach ($courses as $course) {
            $coursecount ++;
            $classes = ($coursecount % 2) ? 'odd' : 'even';
            if ($coursecount == 1) {
                $classes .= ' first';
            }
            if ($coursecount >= count($courses)) {
                $classes .= ' last';
            }
            if ($theme != 'edifirenderer') {
                $content .= $this->coursecat_coursebox($chelper, $course, $classes);
            } else {
                $content2 .= \theme_edifi\extra_blocks::combo_coursebox($course, '');
            }
        }
        $content .= $this->theme_edifi_categories($content2);
        if (!empty($pagingbar)) {
            $content .= $pagingbar;
        }
        if (!empty($morelink)) {
            $content .= $morelink;
        }
        $content .= html_writer::end_tag('div'); // .courses
        return $content;
    }

    /**
     * Returns the course content of course details
     * @param type $content2
     * @return type
     */
    public function theme_edifi_categories($content2) {
        $content = html_writer::start_tag('div', ['class' => 'course-block']);
        $content .= html_writer::start_tag('div', ['class' => 'course-categories-block']);
        $content .= html_writer::start_tag('div', ['class' => 'card-block']);
        $content .= html_writer::start_tag('div', ['class' => 'container']);
        $content .= html_writer::start_tag('div', ['class' => 'row filtr-container']);
        $content .= $content2;
        $content .= html_writer::end_tag('div'); // .container.
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div'); // .container.
        $content .= html_writer::end_tag('div');
        $content .= html_writer::end_tag('div');
        return $content;
    }

    public function coursepage_title(coursecat_helper $chelper, $coursecat, $depth, $custompage='') {
        global $CFG;
        $categoryid = optional_param('categoryid', 0, PARAM_INT);
        $output = html_writer::label(get_string('categories').':', 'categories_list' );
        $output .= html_writer::start_tag('div', ['class' => 'dropdown dropdown-subcategory  categorypicker']);
        $ddid = 'dropdownMenu_coursepage';
        $output .= html_writer::tag('button', 'All', ["class" => "btn btn-secondary dropdown-toggle", "type" => "button", "id" => $ddid, "data-bs-toggle" => "dropdown", "aria-haspopup" => "true", "aria-expanded" => "false"]);
        $select = html_writer::start_tag('div', ['class' => 'dropdown-menu simplefilter', 'aria-labelledby' => $ddid, 'name' => 'categoryid']);
        $courseArrs = core_course_category::make_categories_list();
        // $select .= html_writer::tag('li','');
        $select .= html_writer::tag('a', "ALL", ['class' => 'category-filter dropdown-item ', 'href' => 'javascript:void(0)', 'data-filter' => 'all']);
        foreach ($courseArrs as $key => $courseArr) {
            $selected = ($categoryid == $key) ? 'selected' : "false";
            $select .= html_writer::tag('a', $courseArr, ['class' => 'category-filter dropdown-item ', 'href' => 'javascript:void(0)', 'data-filter' => $key ]);
        }
        $select .= html_writer::end_tag('div');
        $output .= $select;
        // $output .= $this->render($select);
        $output .= html_writer::end_tag('div'); // .categorypicker
        return $output;
    }
    /**
     * Output news for the frontpage (extract from site-wide news forum)
     *
     * @param stdClass $newsforum record from db table 'forum' that represents the site news forum
     * @return string
     */
    /* protected function frontpage_news($newsforum) {
        global $CFG, $SITE, $SESSION, $USER;
        require_once($CFG->dirroot .'/mod/forum/lib.php');

        $output = '';

        if (isloggedin()) {
            $SESSION->fromdiscussion = $CFG->wwwroot;
            $subtext = '';
            if (\mod_forum\subscriptions::is_subscribed($USER->id, $newsforum)) {
                if (!\mod_forum\subscriptions::is_forcesubscribed($newsforum)) {
                    $subtext = get_string('unsubscribe', 'forum');
                }
            } else {
                $subtext = get_string('subscribe', 'forum');
            }
            $suburl = new moodle_url('/mod/forum/subscribe.php', array('id' => $newsforum->id, 'sesskey' => sesskey()));
            $output .= html_writer::tag('div', html_writer::link($suburl, $subtext), array('class' => 'subscribelink'));
        }

        ob_start();
        forum_print_latest_discussions($SITE, $newsforum, $SITE->newsitems, 'plain', 'p.modified DESC');
        $output .= ob_get_contents();
        ob_end_clean();

        return $output;
    }*/

     public function get_courseimage($course) {
        global $CFG, $OUTPUT;

        if (!empty($course)) {
            $imgurl = $OUTPUT->image_url('no-image', 'theme');           
            foreach ($course->get_course_overviewfiles() as $file) {
                $isimage = $file->is_valid_image();
                if ($isimage) {                 
                    $imgurl = file_encode_url("$CFG->wwwroot/pluginfile.php",
                    '/'. $file->get_contextid(). '/'. $file->get_component(). '/'.
                    $file->get_filearea(). $file->get_filepath(). $file->get_filename(), !$isimage);    
                }
            }                       
            return $imgurl;
        }
    }


    //return select category courses 


    public function get_category_courses($categoryid,$parentid = '') {

        global $CFG, $OUTPUT, $PAGE;

        if ($parentid) {
            $subcateid = $categoryid;
            $categoryid = $parentid;
        }

        $chelper = new coursecat_helper();
        $chelper->set_show_courses(self::COURSECAT_SHOW_COURSES_EXPANDED)->
                set_courses_display_options([
                    'recursive' => true,
                    'limit' => $CFG->frontpagecourselimit,
                    'viewmoreurl' => new moodle_url('/course/index.php'),
                    'viewmoretext' => new lang_string('fulllistofcourses')]);

        if ($categoryid == 'all') {
           /* $courses = $this->edifi_frontpacombolist($chelper,core_course_category::get(0),true);*/
            $parentCategory = core_course_category::get(0)->get_children($chelper->get_categories_display_options());
            $courses = [];
            if (!empty($parentCategory)) {
                foreach ($parentCategory as $category) {

                    $listcourses = core_course_category::get($category->id)->get_courses($chelper->get_courses_display_options());
                    if (!empty($listcourses)) {
                        foreach($listcourses as $course) {
                            array_push($courses,$course);
                        }
                    }
                  
                }
            }

        } else {
            $coursecat = core_course_category::get($categoryid);
            $courses = $coursecat->get_courses($chelper->get_courses_display_options()); 
            $subcategoryids = core_course_category::get($categoryid)->get_all_children_ids();   

        }
        if ($parentid) {

            $coursecat = core_course_category::get($subcateid);
            $courses = $coursecat->get_courses($chelper->get_courses_display_options());
        }
        $subcategorys = [];
        $listcourses = [];
        if (!empty($subcategoryids)) {

            foreach ($subcategoryids as $subcategory) {
              
                $category = core_course_category::get($subcategory);
                $list['name'] = $category->get_formatted_name();
                $list['id'] = $category->id;
                array_push($subcategorys, $list);
            }
        }
     
        if (!empty($courses)) {

            foreach ($courses as $course) {

                $list['coursename'] = $chelper->get_course_formatted_name($course);
                $list['courseurl'] = new moodle_url('/course/view.php', ['id' => $course->id]);
                $list['courseimage'] = $this->get_courseimage($course);
                array_push($listcourses,$list);
            }
        }
        if (count($listcourses) > 8) {
            $template['show_arrow'] = true;
        } else {
            $template['show_arrow'] = false;
        }
        $template['courses'] = array_chunk($listcourses,8);
        $template['subcategory'] = $subcategorys;
        $template['title'] = !empty ($subcategorys) ? get_string('selectsubcategory','theme_edifi') : get_string('none','theme_edifi');
        $template['subcategorytoggle'] = !empty($subcategorys);
        $template['subtrue'] = !empty($subcategorys) ? true : false;
        $template['parentCate'] = $categoryid;
        return $OUTPUT->render_from_template('theme_edifi/available-course-item',$template);

    }
}
