<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    theme_edifi
 * @copyright  2015 onwards LMSACE Dev Team (http://www.lmsace.com)
 * @author    LMSACE Dev Team
 */

defined('MOODLE_INTERNAL') || die;

$settings = null;
if (is_siteadmin()) {

    $settings = new theme_boost_admin_settingspage_tabs('themesettingedifi', get_string('configtitle', 'theme_edifi') );

    /* Header Settings */
    $temp = new admin_settingpage('theme_edifi_general', get_string('themegeneralsettings', 'theme_edifi'));

    // This is the descriptor for Slide One.
    $name = 'theme_edifi/theme_edifi_generalsub1';
    $heading = get_string('generallogo_menu', 'theme_edifi');
    $information = "";
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Color pattern type
    /*$name = 'theme_edifi/patternstatus';
    $title = get_string('patternstatus', 'theme_edifi');
    $description = get_string('patternstatusdesc', 'theme_edifi');
    $pattern = get_string('pattern', 'theme_edifi');
    $colorpicker = get_string('colorpicker', 'theme_edifi');
    $default = 1;
    $choices = array(1 => $pattern , 2 => $colorpicker);
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);*/

    // Preloader Color.
    $name = 'theme_edifi/patternselect';
    $title = get_string('patternselect', 'theme_edifi');
    $description = get_string('patternselectdesc', 'theme_edifi');
    $default = 'rose';
    $previewconfig = null;
    $rose = get_string('rose', 'theme_edifi');
    $yellow = get_string('yellow', 'theme_edifi');
    $darkblue = get_string('darkblue', 'theme_edifi');
    $green = get_string('green', 'theme_edifi');
    $orange = get_string('orange', 'theme_edifi');
    $custom = get_string('customcolor', 'theme_edifi');
    $choices = ["rose" => $rose, "yellow" => $yellow, "darkblue" => $darkblue, "green" => $green, "orange" => $orange, 'custom' => $custom ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Pattern color.
    $name = 'theme_edifi/patterncolor';
    $title = get_string('patterncolor', 'theme_edifi');
    $description = get_string('patterncolor_desc', 'theme_edifi');
    $default = "#ff5252";
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);


    // Logo file setting.
    $name = 'theme_edifi/logo';
    $title = get_string('logo', 'theme_edifi');
    $description = get_string('logodesc', 'theme_edifi');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'logo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Sticky logo file.
    $name = 'theme_edifi/stickylogo';
    $title = get_string('stickylogo', 'theme_edifi');
    $description = get_string('stickylogodesc', 'theme_edifi');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'stickylogo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Header style.
    $name = 'theme_edifi/headerStyle';
    $title = get_string('headerStyletitle' , 'theme_edifi');
    $description = get_string('headerStyledesc', 'theme_edifi');
    $default = '1';
    $choices = [
        '1' => get_string('headerStyle4', 'theme_edifi'),
        '2' => get_string('headerStyle2', 'theme_edifi'),
        '3' => get_string('headerStyle3', 'theme_edifi'),
        '4' => get_string('headerStyle1', 'theme_edifi'),
    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Transparent header.
    $name = 'theme_edifi/headerTransparent';
    $title = get_string('headerTransparent' , 'theme_edifi');
    $description = get_string('headerTransparentdesc', 'theme_edifi');
    $default = '1';
    $choices = [
        '1' => get_string('enable', 'theme_edifi'),
        '0' => get_string('disable', 'theme_edifi'),
    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Header Overlay.
    $name = 'theme_edifi/headerOverlay';
    $title = get_string('header_overlay', 'theme_edifi');
    $description = get_string('header_overlaydesc', 'theme_edifi');
    $default = '1';
    $choices = [
        1 => get_string('enable', 'theme_edifi'),
        0 => get_string('disable', 'theme_edifi'),
    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Header Height.
    $name = 'theme_edifi/headerHeight';
    $title = get_string('headerHeight', 'theme_edifi');
    $description = get_string('headerHeight_desc', 'theme_edifi');
    $default = '75';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // This is the descriptor for Slide One.
    $name = 'theme_edifi/theme_edifi_managefrontpage';
    $heading = get_string('managefrontpage_items', 'theme_edifi');
    $information = "";// get_string('slidenodesc', 'theme_edifi', array('slide' => $i));
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

     // Featured courses block.
    $name = 'theme_edifi/featured_courses';
    $title = get_string('fcourses', 'theme_edifi');
    $description = get_string('fcoursesdesc', 'theme_edifi');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Featured course title.
    $name = 'theme_edifi/fcoursetitle';
    $title = get_string('fcoursetitle', 'theme_edifi');
    $description = get_string('fcoursetitle_desc', 'theme_edifi');
    $default = 'lang:fcourses';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    $temp->add($setting);

    // Featured course description.
    $name = 'theme_edifi/fcoursedesc';
    $title = get_string('fcoursedesc', 'theme_edifi');
    $description = get_string('fcoursedesc_desc', 'theme_edifi');
    $default = 'lang:loreum';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
    $temp->add($setting);

    // Available Course Display Status.
    $name = 'theme_edifi/availablecourse_displaytype';
    $title = get_string('acourse_displaytype' , 'theme_edifi');
    $description = get_string('acourse_displaytypedesc', 'theme_edifi');
    $default = '1';
    $choices = [
        '0' => get_string('default_type', 'theme_edifi'),
        '1' => get_string('theme_based', 'theme_edifi'),

    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Available Course Display Status.
    $name = 'theme_edifi/availablecourse_title';
    $title = get_string('acourse_title' , 'theme_edifi');
    $description = get_string('acourse_titledesc', 'theme_edifi');
    $default = get_string('availablecourses');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Available course description.
    $name = 'theme_edifi/availablecourse_desc';
    $title = get_string('acourse_desc' , 'theme_edifi');
    $description = get_string('acoursedesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Mycourse Course Display Type.
    $name = 'theme_edifi/mycourse_displaytype';
    $title = get_string('mycourse_displaytype' , 'theme_edifi');
    $description = get_string('mycourse_displaytypedesc', 'theme_edifi');
    $default = '1';
    $choices = [
        '0' => get_string('default_type', 'theme_edifi'),
        '1' => get_string('slider_type', 'theme_edifi'),

    ];

    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Available Course Display Status.
    $name = 'theme_edifi/mycourse_title';
    $title = get_string('mycourse_title' , 'theme_edifi');
    $description = get_string('mycourse_titledesc', 'theme_edifi');
    $default = get_string('mycourses');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // My course description.
    $name = 'theme_edifi/mycourse_desc';
    $title = get_string('mycourse_desc' , 'theme_edifi');
    $description = get_string('mycoursedesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Categories Displaytype
    $name = 'theme_edifi/categories_displaytype';
    $title = get_string('categories_displaytype' , 'theme_edifi');
    $description = get_string('categories_displaytypedesc', 'theme_edifi');
    $default = '1';
    $choices = [
        '0' => get_string('default', 'theme_edifi'),
        '1' => get_string('theme_based', 'theme_edifi'),
    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);

    $temp->add($setting);

    // Available Course Display Status.
    $name = 'theme_edifi/coursecat_title';
    $title = get_string('coursecat_title' , 'theme_edifi');
    $description = get_string('coursecat_titledesc', 'theme_edifi');
    $default = get_string('categories');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Course category description.
    $name = 'theme_edifi/coursecat_desc';
    $title = get_string('coursecat_desc' , 'theme_edifi');
    $description = get_string('coursecatdesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Sitenews title.
    $name = 'theme_edifi/sitenews_title';
    $title = get_string('sitenews_title' , 'theme_edifi');
    $description = get_string('sitenews_titledesc', 'theme_edifi');
    $default = get_string('sitenews');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Sitenews Description.
    $name = 'theme_edifi/sitenews_desc';
    $title = get_string('sitenews_desc' , 'theme_edifi');
    $description = get_string('sitenewsdesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // combo list box type
    $name = 'theme_edifi/comboListboxType';
    $title = get_string('comboListboxType', 'theme_edifi');
    $description = get_string('comboListboxType_desc', 'theme_edifi');
    $yes = get_string('edifi_type', 'theme_edifi');
    $no = get_string('default_type', 'theme_edifi');
    $default = 1;
    $choices = [ 0 => $no , 1 => $yes ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Combolist Title.
    $name = 'theme_edifi/combolist_title';
    $title = get_string('combolist_title' , 'theme_edifi');
    $description = get_string('combolist_titledesc', 'theme_edifi');
    $default = get_string('courses');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Combolist Description.
    $name = 'theme_edifi/combolist_desc';
    $title = get_string('combolist_desc' , 'theme_edifi');
    $description = get_string('combolistdesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Course search title.
    $name = 'theme_edifi/csearch_title';
    $title = get_string('csearch_title' , 'theme_edifi');
    $description = get_string('csearch_titledesc', 'theme_edifi');
    $default = get_string('searchcourses');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Course search description.
    $name = 'theme_edifi/csearch_desc';
    $title = get_string('csearch_desc' , 'theme_edifi');
    $description = get_string('csearchdesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // This is the descriptor for Slide One.
    $name = 'theme_edifi/theme_edifi_miscellaneous';
    $heading = get_string('miscellaneous', 'theme_edifi');
    $information = "";// get_string('slidenodesc', 'theme_edifi', array('slide' => $i));
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Course layout.
    $name = 'theme_edifi/courselayout';
    $title = get_string('courselayout' , 'theme_edifi');
    $description = get_string('courselayoutdesc', 'theme_edifi');
    $default = 'themebased';
    $choices = [
        'default' => get_string('default_layout', 'theme_edifi'),
        'themebased' => get_string('custom_layout', 'theme_edifi').'-1',
    ];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

     // Login background file setting.
    $name = 'theme_edifi/loginbg';
    $title = get_string('loginBG', 'theme_edifi');
    $description = get_string('loginBG_desc', 'theme_edifi');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'loginbg');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Custom CSS file.
    $name = 'theme_edifi/customcss';
    $title = get_string('customcss', 'theme_edifi');
    $description = get_string('customcssdesc', 'theme_edifi');
    $default = '';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Import Demo Content
    $name = 'theme_edifi/importDemo';
    $title = get_string('importDemo', 'theme_edifi');
    $description = get_string('importDemo_desc', 'theme_edifi');
    $default = 0;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Preloader Status.
    $name = 'theme_edifi/preloader_status';
    $title = get_string('preloader_status', 'theme_edifi');
    $description = get_string('preloader_statusdesc', 'theme_edifi');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 0;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Preloader Color.
    $name = 'theme_edifi/preloaderbg_color';
    $title = get_string('preloaderbg_color', 'theme_edifi');
    $description = get_string('preloaderbg_colordesc', 'theme_edifi');
    $default = "#353535";
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $temp->add($setting);

    // Preloader Image.
    $name = 'theme_edifi/preloader';
    $title = get_string('preloader', 'theme_edifi');
    $description = get_string('preloader_desc', 'theme_edifi');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'preloader');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Back to top status.
    $name = 'theme_edifi/backToTop_status';
    $title = get_string('backToTop_status', 'theme_edifi');
    $description = get_string('backToTop_statusdesc', 'theme_edifi');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    $settings->add($temp); // General settings tap closed.


    /******** Slideshow Settings Start ********/
    $temp = new admin_settingpage('theme_edifi_slideshow', get_string('slideshowheading', 'theme_edifi'));
    $temp->add(new admin_setting_heading('theme_edifi_slideshow', get_string('slideshowheadingsub', 'theme_edifi'),
        format_text(get_string('slideshowdesc', 'theme_edifi'), FORMAT_MARKDOWN)));
     // Display Slideshow.
    $name = 'theme_edifi/toggleslideshow';
    $title = get_string('toggleslideshow', 'theme_edifi');
    $description = get_string('toggleslideshowdesc', 'theme_edifi');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Number of slides.
    $name = 'theme_edifi/numberofslides';
    $title = get_string('numberofslides', 'theme_edifi');
    $description = get_string('numberofslides_desc', 'theme_edifi');
    $default = 1;
    $choices = [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
    ];
    $temp->add(new admin_setting_configselect($name, $title, $description, $default, $choices));



    // Auto Scroll.
    $name = 'theme_edifi/autoslideshow';
    $title = get_string('autoplay', 'theme_edifi');
    $description = get_string('autoslideshowdesc', 'theme_edifi');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Slideshow Controls selection.
    $name = 'theme_edifi/slideshowControls';
    $title = get_string('slideshowControls', 'theme_edifi');
    $description = get_string('slideshowControls_desc', 'theme_edifi');
    $doted = get_string('doted', 'theme_edifi');
    $thumb = get_string('thumb', 'theme_edifi');
    $none = get_string('none', 'theme_edifi' );
    $default = "DOTED";
    $choices = [ 'DOTED' => $doted , 'THUMB' => $thumb, 'NONE' => $none];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Slide Show Interval.
    $name = 'theme_edifi/slideinterval';
    $title = get_string('slideinterval', 'theme_edifi');
    $description = get_string('slideintervaldesc', 'theme_edifi');
    $default = 3000;
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_INT);
    $temp->add($setting);

    // Slideshow Height.
    $name = 'theme_edifi/slideHeight';
    $title = get_string('slideheight', 'theme_edifi');
    $description = get_string('slideheight_desc', 'theme_edifi');
    $default = '550px';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Slideshow Height.
    $name = 'theme_edifi/canvasSize';
    $title = get_string('canvasSize', 'theme_edifi');
    $description = get_string('canvasSize_desc', 'theme_edifi');
    $default = '105';
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Slide overlay color.
    $name = 'theme_edifi/canvasColor';
    $title = get_string('canvasColor', 'theme_edifi');
    $description = get_string('canvasColor_desc', 'theme_edifi');
    $default = "#ff5252";
    $previewconfig = null;
    $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
    $temp->add($setting);

    $animations = [
        "none" => get_string('no'),
        "flash" => get_string('flash', 'theme_edifi'),
        "bounceIn" => get_string('bounceIn', 'theme_edifi'),
        "bounceInDown" => get_string('bounceInDown', 'theme_edifi'),
        "bounceInLeft" => get_string('bounceInLeft', 'theme_edifi'),
        "bounceInRight" => get_string('bounceInRight', 'theme_edifi'),
        "bounceInUp" => get_string('bounceInUp', 'theme_edifi'),
        "fadeIn" => get_string('fadeIn', 'theme_edifi'),
        "fadeInDown" => get_string('fadeInDown', 'theme_edifi'),
        "fadeInDownBig" => get_string('fadeInDownBig', 'theme_edifi'),
        "fadeInLeft" => get_string('fadeInLeft', 'theme_edifi'),
        "fadeInLeftBig" => get_string('fadeInLeftBig', 'theme_edifi'),
        "fadeInRight" => get_string('fadeInRight', 'theme_edifi'),
        "fadeInRightBig" => get_string('fadeInRightBig', 'theme_edifi'),
        "fadeInUp" => get_string('fadeInUp', 'theme_edifi'),
        "fadeInUpBig" => get_string('fadeInUpBig', 'theme_edifi'),
        "fadeOut" => get_string('fadeOut', 'theme_edifi'),
        "flip" => get_string('flip', 'theme_edifi'),
        "flipInX" => get_string('flipInX', 'theme_edifi'),
        "flipInY" => get_string('flipInY', 'theme_edifi'),
        "flipOutX" => get_string('flipOutX', 'theme_edifi'),
        "flipOutY" => get_string('flipOutY', 'theme_edifi'),
        "lightSpeedIn" => get_string('lightSpeedIn', 'theme_edifi'),
        "rotateIn" => get_string('rotateIn', 'theme_edifi'),
        "rotateInDownLeft" => get_string('rotateInDownLeft', 'theme_edifi'),
        "rotateInDownRight" => get_string('rotateInDownRight', 'theme_edifi'),
        "rotateInUpLeft" => get_string('rotateInUpLeft', 'theme_edifi'),
        "rotateInUpRight" => get_string('rotateInUpRight', 'theme_edifi'),
        "slideInUp" => get_string('slideInUp', 'theme_edifi'),
        "slideInDown" => get_string('slideInDown', 'theme_edifi'),
        "slideInLeft" => get_string('slideInLeft', 'theme_edifi'),
        "slideInRight" => get_string('slideInRight', 'theme_edifi'),
        "zoomIn" => get_string('zoom-In1', 'theme_edifi'),
        "zoomInDown" => get_string('zoomInDown', 'theme_edifi'),
        "zoomInLeft" => get_string('zoomInLeft', 'theme_edifi'),
        "zoomInRight" => get_string('zoomInRight', 'theme_edifi'),
        "zoomInUp" => get_string('zoomInUp', 'theme_edifi'),
        "hinge" => get_string('hinge', 'theme_edifi'),
        "rollIn" => get_string('rollIn', 'theme_edifi'),
    ];

    $effects = [
        'random' => get_string('random', 'theme_edifi'),
        'slide' => get_string('slide', 'theme_edifi'),
        'fade' => get_string('fade', 'theme_edifi'),
        'fadeOutIn' => get_string('fadeOutIn', 'theme_edifi'),
        'foldDown' => get_string('foldDown', 'theme_edifi'),
        'foldLeft' => get_string('foldLeft', 'theme_edifi'),
        'foldRandomHorizontal' => get_string('foldRandomHorizontal', 'theme_edifi'),
        'foldRandomVertical' => get_string('foldRandomVertical', 'theme_edifi'),
        'foldRight' => get_string('foldRight', 'theme_edifi'),
        'foldUp' => get_string('foldUp', 'theme_edifi'),
        'pushInDown' => get_string('pushInDown', 'theme_edifi'),
        'pushInLeft' => get_string('pushInLeft', 'theme_edifi'),
        'pushInRight' => get_string('pushInRight', 'theme_edifi'),
        'pushInUp' => get_string('pushInUp', 'theme_edifi'),
        'pushOutDown' => get_string('pushOutDown', 'theme_edifi'),
        'pushOutLeft' => get_string('pushOutLeft', 'theme_edifi'),
        'pushOutRight' => get_string('pushOutRight', 'theme_edifi'),
        'pushOutUp' => get_string('pushOutUp', 'theme_edifi'),
        'blinds1Up' => get_string('blinds1Up', 'theme_edifi'),
        'blinds1Right' => get_string('blinds1Right', 'theme_edifi'),
        'blinds1Down' => get_string('blinds1Down', 'theme_edifi'),
        'blinds1Left' => get_string('blinds1Left', 'theme_edifi'),
        'blinds2Up' => get_string('blinds2Up', 'theme_edifi'),
        'blinds2Right' => get_string('blinds2Right', 'theme_edifi'),
        'blinds2Down' => get_string('blinds2Down', 'theme_edifi'),
        'blinds2Left' => get_string('blinds2Left', 'theme_edifi'),
        'revealDown' => get_string('revealDown', 'theme_edifi'),
        'revealLeft' => get_string('revealLeft', 'theme_edifi'),
        'revealRight' => get_string('revealRight', 'theme_edifi'),
        'revealUp' => get_string('revealUp', 'theme_edifi'),
        'sliceDown' => get_string('sliceDown', 'theme_edifi'),
        'sliceLeft' => get_string('sliceLeft', 'theme_edifi'),
        'sliceRight' => get_string('sliceRight', 'theme_edifi'),
        'sliceUp' => get_string('sliceUp', 'theme_edifi'),
        'sliceFadeDown' => get_string('sliceFadeDown', 'theme_edifi'),
        'sliceFadeLeft' => get_string('sliceFadeLeft', 'theme_edifi'),
        'sliceFadeRight' => get_string('sliceFadeRight', 'theme_edifi'),
        'sliceFadeUp' => get_string('sliceFadeUp', 'theme_edifi'),
        'sliceRevealDown' => get_string('sliceRevealDown', 'theme_edifi'),
        'sliceRevealLeft' => get_string('sliceRevealLeft', 'theme_edifi'),
        'sliceRevealRight' => get_string('sliceRevealRight', 'theme_edifi'),
        'sliceRevealUp' => get_string('sliceRevealUp', 'theme_edifi'),
        'sliceRevealRandomDown' => get_string('sliceRevealRandomDown', 'theme_edifi'),
        'sliceRevealRandomLeft' => get_string('sliceRevealRandomLeft', 'theme_edifi'),
        'sliceRevealRandomRight' => get_string('sliceRevealRandomRight', 'theme_edifi'),
        'sliceRevealRandomUp' => get_string('sliceRevealRandomUp', 'theme_edifi'),
        'sliceRevealReverseDown' => get_string('sliceRevealReverseDown', 'theme_edifi'),
        'sliceRevealReverseLeft' => get_string('sliceRevealReverseLeft', 'theme_edifi'),
        'sliceRevealReverseRight' => get_string('sliceRevealReverseRight', 'theme_edifi'),
        'sliceRevealReverseUp' => get_string('sliceRevealReverseUp', 'theme_edifi'),
        'stackDown' => get_string('stackDown', 'theme_edifi'),
        'stackDownReverse' => get_string('stackDownReverse', 'theme_edifi'),
        'stackLeft' => get_string('stackLeft', 'theme_edifi'),
        'stackLeftReverse' => get_string('stackLeftReverse', 'theme_edifi'),
        'stackRight' => get_string('stackRight', 'theme_edifi'),
        'stackRightReverse' => get_string('stackRightReverse', 'theme_edifi'),
        'stackUp' => get_string('stackUp', 'theme_edifi'),
        'stackUpReverse' => get_string('stackUpReverse', 'theme_edifi'),
        'unzipLeft' => get_string('unzipLeft', 'theme_edifi'),
        'unzipRight' => get_string('unzipRight', 'theme_edifi'),
        'zipLeft' => get_string('zipLeft', 'theme_edifi'),
        'zipRight' => get_string('zipRight', 'theme_edifi'),


        ];

    // Slide Caption bg colour setting.
    $numberofslides = get_config('theme_edifi', 'numberofslides');
    for ($i = 1; $i <= $numberofslides; $i++) {

        // This is the descriptor for Slide One
        $name = 'theme_edifi/slide' . $i . 'info';
        $heading = get_string('slideno', 'theme_edifi', ['slide' => $i]);
        $information = get_string('slidenodesc', 'theme_edifi', ['slide' => $i]);
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);


         // SlideShow Status
        $name = 'theme_edifi/slide'.$i.'status';
        $title = get_string('slideStatus', 'theme_edifi', ['slide' => $i]);
        $description = get_string('slideStatus_desc', 'theme_edifi', ['slide' => $i]);
        $yes = get_string('enable', 'theme_edifi');
        $no = get_string('disable', 'theme_edifi');
        $default = 1;
        $choices = [1 => $yes , 0 => $no];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);

        $temp->add($setting);

        // Slider type.
        $name = 'theme_edifi/slide' . $i . 'type';
        $title = get_string('slidetype', 'theme_edifi');
        $description = get_string('slidetype_desc', 'theme_edifi', ['slideno' => $i] );
        $img = get_string('image', 'theme_edifi');
        $video = get_string('video', 'theme_edifi');
        $default = 'IMAGE';
        $choices = [ 'IMAGE' => $img , 'VIDEO' => $video];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);

        $temp->add($setting);

        // Slide Image.
        $name = 'theme_edifi/slide' . $i . 'image';
        $title = get_string('slideimage', 'theme_edifi', ['slide' => $i]);
        $description = get_string('slideimagedesc', 'theme_edifi');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'slide' . $i . 'image');
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Caption.
        $name = 'theme_edifi/slide' . $i . 'video';
        $title = get_string('slidevideo', 'theme_edifi', ['slideno' => $i ]);
        $description = get_string('slidevideo_desc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);

        $temp->add($setting);

        // Slide Image.
        $name = 'theme_edifi/slide' . $i . 'posterimage';
        $title = get_string('posterimage', 'theme_edifi', ['slide' => $i]);
        $description = get_string('posterimagedesc', 'theme_edifi');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'slide' . $i . 'posterimage');
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        // Slide Volume.
       /* $name = 'theme_edifi/slide'. $i .'volume';
        $title = get_string('slidevolume', 'theme_edifi');
        $description = get_string('slidevolume_desc', 'theme_edifi');
        $yes = get_string('yes');
        $no = get_string('no');
        $default = 1;
        $choices = array( 0 => $yes , 1 => $no);
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);*/

        // Slide Caption.
        $name = 'theme_edifi/slide' . $i . 'caption';
        $title = get_string('slidecaption', 'theme_edifi', ['slide' => $i]);
        $description = get_string('slidecaptiondesc', 'theme_edifi');
        $default = get_string('slidecaptiondefault', 'theme_edifi', ['slideno' => sprintf('%02d', $i) ]);
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);

        $temp->add($setting);

        // Slide Description Text.
        $name = 'theme_edifi/slide' . $i . 'desc';
        $title = get_string('slidedesc', 'theme_edifi', ['slide' => $i]);
        $description = get_string('slidedesctext', 'theme_edifi');
        $default = 'lang:slidedescdefault';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);

        $temp->add($setting);

        // Slide URL Text.
        $name = 'theme_edifi/slide' . $i . 'urltext1';
        $title = get_string('slideurl1text', 'theme_edifi');
        $description = get_string('slideurl1textdesc', 'theme_edifi');
        $default = 'lang:readmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);

        $temp->add($setting);

        // Slide URL.
        $name = 'theme_edifi/slide' . $i . 'url1';
        $title = get_string('slideurl1', 'theme_edifi');
        $description = get_string('slideurl1desc', 'theme_edifi');
        $default = get_string('buytheme', 'theme_edifi');
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);

        $temp->add($setting);

        // Slide URL target.
        $name = 'theme_edifi/slide'.$i.'urltarget1';
        $title = get_string('urltarget1', 'theme_edifi', ['type' => "2"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        // $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);


        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext2';
        $title = get_string('slideurl2text', 'theme_edifi', ['type' => "2"]);
        $description = get_string('slideurl2textdesc', 'theme_edifi');
        $default = 'lang:readmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 2.
        $name = 'theme_edifi/slide' . $i . 'url2';
        $title = get_string('slideurl2', 'theme_edifi', ['type' => "2"]);
        $description = get_string('slideurl2desc', 'theme_edifi');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 2 target.
        $name = 'theme_edifi/slide'.$i.'urltarget2';
        $title = get_string('urltarget2', 'theme_edifi', ['type' => "2"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);

        // Code ISLEM PHP  Ligne 763
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext3';
        $title = get_string('slideurl3text', 'theme_edifi', ['type' => "3"]);
        $description = get_string('slideurl3textdesc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 3.
        $name = 'theme_edifi/slide' . $i . 'url3';
        $title = get_string('slideurl3', 'theme_edifi', ['type' => "3"]);
        $description = get_string('slideurl3desc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 3 target.
        $name = 'theme_edifi/slide'.$i.'urltarget3';
        $title = get_string('urltarget3', 'theme_edifi', ['type' => "3"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        //#######################################################
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext4';
        $title = get_string('slideurl4text', 'theme_edifi', ['type' => "4"]);
        $description = get_string('slideurl4textdesc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 4.
        $name = 'theme_edifi/slide' . $i . 'url4';
        $title = get_string('slideurl4', 'theme_edifi', ['type' => "4"]);
        $description = get_string('slideurl4desc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 4 target.
        $name = 'theme_edifi/slide'.$i.'urltarget4';
        $title = get_string('urltarget4', 'theme_edifi', ['type' => "4"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        //#######################################################
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext5';
        $title = get_string('slideurl5text', 'theme_edifi', ['type' => "5"]);
        $description = get_string('slideurl5textdesc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 5.
        $name = 'theme_edifi/slide' . $i . 'url5';
        $title = get_string('slideurl5', 'theme_edifi', ['type' => "5"]);
        $description = get_string('slideurl5desc', 'theme_edifi');
        $default = '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 5 target.
        $name = 'theme_edifi/slide'.$i.'urltarget5';
        $title = get_string('urltarget5', 'theme_edifi', ['type' => "5"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        //#######################################################
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext6';
        $title = get_string('slideurl6text', 'theme_edifi', ['type' => "6"]);
        $description = get_string('slideurl6textdesc', 'theme_edifi');
        $default = 'lang:readmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 6.
        $name = 'theme_edifi/slide' . $i . 'url6';
        $title = get_string('slideurl6', 'theme_edifi', ['type' => "6"]);
        $description = get_string('slideurl6desc', 'theme_edifi');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 6 target.
        $name = 'theme_edifi/slide'.$i.'urltarget6';
        $title = get_string('urltarget6', 'theme_edifi', ['type' => "6"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        //#######################################################
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext7';
        $title = get_string('slideurl7text', 'theme_edifi', ['type' => "7"]);
        $description = get_string('slideurl7textdesc', 'theme_edifi');
        $default = 'lang:readmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 7.
        $name = 'theme_edifi/slide' . $i . 'url7';
        $title = get_string('slideurl7', 'theme_edifi', ['type' => "7"]);
        $description = get_string('slideurl7desc', 'theme_edifi');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 7 target.
        $name = 'theme_edifi/slide'.$i.'urltarget7';
        $title = get_string('urltarget7', 'theme_edifi', ['type' => "7"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        //#######################################################
        // Slide Link text.
        $name = 'theme_edifi/slide' . $i . 'urltext8';
        $title = get_string('slideurl8text', 'theme_edifi', ['type' => "8"]);
        $description = get_string('slideurl8textdesc', 'theme_edifi');
        $default = 'lang:readmore';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // Slide Url 7.
        $name = 'theme_edifi/slide' . $i . 'url8';
        $title = get_string('slideurl8', 'theme_edifi', ['type' => "8"]);
        $description = get_string('slideurl8desc', 'theme_edifi');
        $default = 'http://www.example.com/';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_URL);
        $temp->add($setting);

        // Slide Url 7 target.
        $name = 'theme_edifi/slide'.$i.'urltarget8';
        $title = get_string('urltarget8', 'theme_edifi', ['type' => "8"]);
        $description = get_string('urltarget_desc', 'theme_edifi', ['slide' => $i]);
        $same = get_string('sameWindow', 'theme_edifi');
        $new = get_string('newWindow', 'theme_edifi');
        $default = 1;
        $choices = [0 => $same , 1 => $new];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);
        // Code ISLEM PHP



        // Slide Content style.
        $name = 'theme_edifi/slide'. $i .'contentStyle';
        $title = get_string('slideContentStyle', 'theme_edifi');
        $canvas = get_string('canvasbased', 'theme_edifi');
        $style1 = get_string('style', 'theme_edifi', ['n' => 1]);
        $style2 = get_string('style', 'theme_edifi', ['n' => 2]);
        $default = 2;
        $choices = [ 1 => $style1, 2 => $style2, 3 => $canvas ];
        $description = get_string('slideContentStyle_desc', 'theme_edifi');
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);

        // Slide content width.
        $name = 'theme_edifi/slide' . $i . 'contWidth';
        $title = get_string('slideCont_width', 'theme_edifi');
        $description = get_string('slideCont_width_desc', 'theme_edifi');
        $default = 50;
        $setting = new admin_setting_configtext($name, $title, $description, $default);
        $temp->add($setting);


        // Slider content position.
        $name = 'theme_edifi/slide' . $i . 'contentPosition';
        $title = get_string('slidecontent', 'theme_edifi', ['slide' => $i]);
        $description = get_string('slidecontentdesc', 'theme_edifi');

        $topLeft = get_string("topLeft", "theme_edifi");
        $topCenter = get_string("topCenter", "theme_edifi");
        $topRight = get_string("topRight", "theme_edifi");
        $centerLeft = get_string("centerLeft", "theme_edifi");
        $center = get_string("center", "theme_edifi");
        $centerRight = get_string("centerRight", "theme_edifi");
        $bottomLeft = get_string("bottomLeft", "theme_edifi");
        $bottomCenter = get_string("bottomCenter", "theme_edifi");
        $bottomRight = get_string("bottomRight", "theme_edifi");
        $default = 'right';
        $choices = [
            "topLeft" => $topLeft,
            "topCenter" => $topCenter,
            "topRight" => $topRight,
            "centerLeft" => $centerLeft,
            "center" => $center,
            "centerRight" => $centerRight,
            "bottomLeft" => $bottomLeft,
            "bottomCenter" => $bottomCenter,
            "bottomRight" => $bottomRight,
            ];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);

         // Content color.
        $name = 'theme_edifi/content'. $i .'color';
        $title = get_string('contentcolor', 'theme_edifi');
        $description = get_string('contentcolor_desc', 'theme_edifi');
        $default = "#ffffff";
        $previewconfig = null;
        $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
        $temp->add($setting);

        // Slide Title Animation.
        $name = 'theme_edifi/slide' . $i . 'titleAnimation';
        $title = get_string('titleAnimate', 'theme_edifi');
        $description = get_string('titleAnimatedesc', 'theme_edifi');
        $default = 'fadeInLeft';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $animations);
        $temp->add($setting);

        // Slide Description Animation.
        $name = 'theme_edifi/slide' . $i . 'descriptionAnimation';
        $title = get_string('describtionAnimate', 'theme_edifi');
        $description = get_string('describtionAnimatedesc', 'theme_edifi');
        $default = 'slideInLeft';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $animations);
        $temp->add($setting);

        // Slide Button animation.
        $name = 'theme_edifi/slide' . $i . 'buttonAnimation';
        $title = get_string('buttonAnimate', 'theme_edifi');
        $description = get_string('buttonAnimatedesc', 'theme_edifi');
        $default = 'slideInDown';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $animations);

        $temp->add($setting);

        // Slide Effect.
        $name = 'theme_edifi/slide' . $i . 'effect';
        $title = get_string('slideEffect', 'theme_edifi');
        $description = get_string('slideEffectdesc', 'theme_edifi');
        $default = 'random';
        $setting = new admin_setting_configselect($name, $title, $description, $default, $effects);
        $temp->add($setting);

        // Slide image zoom.
        $name = 'theme_edifi/slide'.$i.'imgZoom';
        $title = get_string('slideImgzoom', 'theme_edifi');
        $description = get_string('slideImgzoom_desc', 'theme_edifi');
        $zoomin = get_string('yes');
        $no = get_string('no');
        $default = 0;
        $choices = [ 1 => $zoomin ,  0 => $no];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);

        // slide Overlay style.
        $name = 'theme_edifi/slide'. $i .'overlayStyle';
        $title = get_string('slideOverlayStyle', 'theme_edifi');
        $description = get_string('slideOverlayStyle_desc', 'theme_edifi');
        $sliderOverlay = get_string('sliderOverlay', 'theme_edifi');
        $contentOverlay = get_string('contentOverlay', 'theme_edifi');
        $none = get_string('nooverlay', 'theme_edifi');
        $default = 2;
        $choices = [ 1 => $sliderOverlay, 2 => $contentOverlay, 3 => $none ];
        $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
        $temp->add($setting);

         // Slide overlay color.
        $name = 'theme_edifi/overlay'.$i.'color';
        $title = get_string('overlaycolor', 'theme_edifi');
        $description = get_string('overlaycolor_desc', 'theme_edifi');
        $default = "#000000";
        $previewconfig = null;
        $setting = new admin_setting_configcolourpicker($name, $title, $description, $default, $previewconfig);
        $temp->add($setting);

        // Slide overlay opacity.
        $name = 'theme_edifi/slideOverlay'.$i.'opacity';
        $title = get_string('slideOverlay', 'theme_edifi');
        $description = get_string('slideOverlay_desc', 'theme_edifi');
        $opacity = array_combine(range(0, 10, 1 ), range(0, 10, 1 ));
        $default = 4;
        $setting = new admin_setting_configselect($name, $title, $description, $default, $opacity);
        $temp->add($setting);

    }
    /**** Slideshow Settings End ****/
    $settings->add($temp);

    /**** Marketing spot Settings ****/
    $temp = new admin_settingpage('theme_edifi_marketingspot', get_string('marketingspotheading', 'theme_edifi'));

    /**** News and Events ****/
    $name = 'theme_edifi_newsblocksheading';
    $heading = get_string('newsblockheading', 'theme_edifi');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // News Block.
    $name = 'theme_edifi/newsblock';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    /* News and Events Block Content */
    $name = 'theme_edifi/newsblockcontent';
    $title = get_string('newsblockcontent', 'theme_edifi');
    $description = get_string('newsblockcontentdesc', 'theme_edifi');
    $default = get_string('newseventcontent', 'theme_edifi');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    $temp->add($setting);
    
    /* Site Feature Blocks Settings */

    $name = 'theme_edifi_sitefblockheading';
    $heading = get_string('sitefblock', 'theme_edifi');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    for ($i = 1; $i <= 4; $i++) {

        /* First Block */
        $name = 'theme_edifi_sitefblock'.$i.'heading';
        $heading = get_string('sitefblock'.$i, 'theme_edifi');
        $information = '';
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

         // Sitefeatured block enable/disable.
        $name = 'theme_edifi/sitefblock'.$i.'status';
        $title = get_string('activateblock', 'theme_edifi');
        $description = get_string('activateblock_desc', 'theme_edifi');
        $default = 1;
        $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
        $temp->add($setting);

        /* First Block Image */
        $name = 'theme_edifi/sitefblock'.$i.'image';
        $title = get_string('sitefblockimage', 'theme_edifi');
        $description = get_string('sitefblockimagedesc', 'theme_edifi');
        $setting = new admin_setting_configstoredfile($name, $title, $description, 'sitefblock'.$i.'image');
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

        /* First Block Title */
        $name = 'theme_edifi/sitefblock'.$i.'title';
        $title = get_string('sitefblocktitle', 'theme_edifi');
        $description = get_string('sitefblocktitledesc', 'theme_edifi');
        $default = 'lang:sb'.$i.'_default_title';
        $setting = new admin_setting_configtext($name, $title, $description, $default);
        $temp->add($setting);

        /* First Block Content */
        $name = 'theme_edifi/sitefblock'.$i.'content';
        $title = get_string('sitefblockcontent', 'theme_edifi');
        $description = get_string('sitefblockcontentdesc', 'theme_edifi');
        $default = 'lang:sb'.$i.'_default_cnt';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default);
        $temp->add($setting);

        // Site Featured Block 1 Link.
        $name = 'theme_edifi/sitefblock'.$i.'link';
         $title = get_string('sitefblocklink', 'theme_edifi', ['n' => $i]);
        $description = get_string('sitefblocklinkdesc', 'theme_edifi', ['n' => $i] );
        $default = "http://www.example.com";
        $setting = new admin_setting_configtext($name, $title, $description, $default);
        $temp->add($setting);

    }


    $settings->add($temp);
    /* Site Feature Blocks End */

    /* Category image Settings */
    $temp = new admin_settingpage('theme_edifi_categoryimg', get_string('categoryimgheading', 'theme_edifi'));

    $temp->add(new admin_setting_heading('theme_edifi_categoryimg', get_string('categoryimgheadingsub', 'theme_edifi'),
    format_text(get_string('categoryimgdesc', 'theme_edifi'), FORMAT_MARKDOWN)));
    // Get all category IDs and their pretty names.

    // Category Row.
    $name = 'theme_edifi/categoryrow';
    $title = get_string('categoryrow', 'theme_edifi');
    $description = get_string('categoryrow_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_INT);
    $temp->add($setting);


    // require_once($CFG->libdir . '/coursecatlib.php');
    $coursecats = core_course_category::make_categories_list();

    // Go through all categories and create the necessary settings.
    foreach ($coursecats as $key => $value) {
        // Category Icons for each category.
        $name = 'theme_edifi/categoryimg';
        $title = $value;
        $description = get_string('categoryimgcategory', 'theme_edifi', ['category' => $value]);
        $default = 'categoryimg'.$key;
        $setting = new admin_setting_configstoredfile($name . $key, $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);
    }
    unset($coursecats);
    $settings->add($temp);

    /* Testimonial Settings */
    $temp = new admin_settingpage('theme_edifi_tmonialhead', get_string('tmonialheading', 'theme_edifi'));

    // Testimonials Heading.
    $name = 'theme_edifi_testimonials';
    $heading = get_string('testiGeneral', 'theme_edifi');
    $information = "";// get_string('tmonialheadingsub_desc', 'theme_edifi');
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Testimonial enable/disable.
    $name = 'theme_edifi/toggletmonial';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    // Number of testimonials.
    $name = 'theme_edifi/numberoftmonials';
    $title = get_string('numberoftmonials', 'theme_edifi');
    $description = get_string('numberoftmonials_desc', 'theme_edifi');
    $default = 1;
    $choices = [
        1 => '1',
        2 => '2',
        3 => '3',
        4 => '4',
        5 => '5',
        6 => '6',
        7 => '7',
        8 => '8',
        9 => '9',
        10 => '10',
        11 => '11',
        12 => '12',
        13 => '13',
        14 => '14',
        15 => '15',
        16 => '16',
    ];
    $temp->add(new admin_setting_configselect($name, $title, $description, $default, $choices));

    // Testimonial autoplay.
    $name = 'theme_edifi/tmonial_autoplay';
    $title = get_string('autoplay', 'theme_edifi');
    $description = get_string('tmonialTraversal_statusdesc', 'theme_edifi');
    $yes = get_string('yes');
    $no = get_string('no');
    $default = 1;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Testimonial autotime.
    $name = "theme_edifi/tmonial_autotime";
    $title = get_string('tmonial_autoTime', 'theme_edifi');
    $description = get_string('tmonialAutotime_desc', 'theme_edifi');
    $default = 1400;
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

     // Testimonial Title.
    $name = 'theme_edifi/tmonialTitle';
    $title = get_string('BlockTitle', 'theme_edifi');
    $description = get_string('tmonialTitle_desc', 'theme_edifi');
    $default = get_string('tmonialTitle_default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
    $temp->add($setting);

    // Testimonial Description.
    $name = 'theme_edifi/tmonialDesc';
    $title = get_string('BlockDesc', 'theme_edifi');
    $description = get_string('tmonialDesc_desc', 'theme_edifi');
    $default = get_string('loreum', 'theme_edifi');
    $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
    $temp->add($setting);



    $numberoftmonials = get_config('theme_edifi', 'numberoftmonials');
    for ($i = 1; $i <= $numberoftmonials; $i++) {

        // Testimonial Heading.
        $name = 'theme_edifi/testimonialno' . $i . 'info';
        $heading = get_string('testimonialno', 'theme_edifi', ['tmonial' => $i]);
        $information = '';// get_string('testimonialnodesc', 'theme_edifi', array('tmonial' => $i));
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

        // User Name.
        $name = 'theme_edifi/tmonial' . $i . 'uname';
        $title = get_string('tmonialuname', 'theme_edifi');
        $description = get_string('tmonialunamedesc', 'theme_edifi');
        $default = ($i == 1) ? get_string('tmonialuname_default', 'theme_edifi') : '';
        $setting = new admin_setting_configtext($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

        // User Type.
        $name = 'theme_edifi/tmonial' . $i . 'utype';
        $title = get_string('tmonialutype', 'theme_edifi');
        $description = get_string('tmonialutypedesc', 'theme_edifi');
        $default = 'Student';
        $temp->add(new admin_setting_configtext($name, $title, $description, $default));

        // Testimonial Image.
        $name = 'theme_edifi/tmonial'. $i . 'img';
        $title = get_string('tmonialimg', 'theme_edifi');
        $description = get_string('tmonialimgdesc', 'theme_edifi');
        $default = 'tmonial'. $i . 'img';
        $setting = new admin_setting_configstoredfile($name , $title, $description, $default);
        $setting->set_updatedcallback('theme_reset_all_caches');
        $temp->add($setting);

         // Testimonial text.
        $name = 'theme_edifi/tmonial' . $i . 'text';
        $title = get_string('tmonialtext', 'theme_edifi');
        $description = get_string('tmonialtextdesc', 'theme_edifi');
        $default = ($i == 1) ? get_string('tmonialtext_default', 'theme_edifi') : '';
        $setting = new admin_setting_configtextarea($name, $title, $description, $default, PARAM_TEXT);
        $temp->add($setting);

    }

    /* Testimonial End */
    $settings->add($temp);

    /******** Counter blocks setting start **********/
    $temp = new admin_settingpage('theme_edifi_counter', get_string('countertabheading', 'theme_edifi'));

    // Counter block heading.
    $name = 'theme_edifi_countBlockheading';
    $heading = get_string('countBlockSetting', 'theme_edifi');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Counter block enable/disable.
    $name = 'theme_edifi/counterBlock';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    // CounterBlock title.
    $name = 'theme_edifi/countBlockTitle';
    $title = get_string('BlockTitle', 'theme_edifi');
    $description = get_string('countBlockTitle_desc', 'theme_edifi');
    $default = 'lang:countBlockTitle_default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Counter block description.
    $name = 'theme_edifi/countBlockDesc';
    $title = get_string('BlockDesc', 'theme_edifi');
    $description = get_string('countBlockDesc_desc', 'theme_edifi');
    $default = 'lang:countBlockDesc_default';
    $setting = new admin_setting_configtextarea($name, $title, $description, $default);
    $temp->add($setting);

    // Counterblock background image.
    $name = 'theme_edifi/counterbg_image';
    $title = get_string('counterbg_img', 'theme_edifi');
    $description = get_string('counterbgimg_desc', 'theme_edifi');
    $default = 'counterbg_image';
    $setting = new admin_setting_configstoredfile($name , $title, $description, $default);
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Counter parallax enable/disable.
    $name = 'theme_edifi/counterParallax';
    $title = get_string('counterParallax', 'theme_edifi', ['slide' => $i]);
    $description = get_string('counterParallax_desc', 'theme_edifi', ['slide' => $i]);
    $yes = get_string('enable', 'theme_edifi');
    $no = get_string('disable', 'theme_edifi');
    $default = 1;
    $choices = [1 => $yes , 0 => $no];
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);
    $count = 4;

    for ($i = 1; $i <= $count; $i++) {
        // Counter inner block heading.
        $name = 'theme_edifi_countBlock'.$i;
        $heading = get_string('countBlock', 'theme_edifi', ['num' => $i]);
        $information = '';
        $setting = new admin_setting_heading($name, $heading, $information);
        $temp->add($setting);

        // Counter block value.
        $name = 'theme_edifi/countBlockValue'.$i;
        $title = get_string('countBlockValue', 'theme_edifi', ['num' => $i]);
        $description = get_string('countBlockValue_desc', 'theme_edifi', ['num' => $i]);
        $default = "50";
        $setting = new admin_setting_configtext($name, $title, $description, $default);
        $temp->add($setting);

        // Counter block Content.
        $name = 'theme_edifi/countBlockContent'.$i;
        $title = get_string('countBlockContent', 'theme_edifi', ['num' => $i]);
        $description = get_string('countBlockContent_desc', 'theme_edifi', ['num' => $i]);
        $default = 'lang:countBlockContent';
        $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
        $temp->add($setting);
    }

    $settings->add($temp);

    $temp = new admin_settingpage('theme_edifi_ourPartners', get_string('ourpartnerheading', 'theme_edifi'));

    // Our partners heading.
    $name = 'theme_edifi_ourPartners';
    $heading = get_string('partnersGeneral', 'theme_edifi');
    $information = '';// get_string('partnersheadingsub_desc', 'theme_edifi');
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Our partner status.
    $name = "theme_edifi/ourPartner_status";
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    // $choices = array(1 => $yes, 0 => $no);
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    $name = "theme_edifi/ourPartner_number";
    $title = get_string('ourPartnernum', 'theme_edifi');
    $description = get_string('ourPartnernum_desc', 'theme_edifi');
    $default = "8";
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Our partner autoplay.
    $name = "theme_edifi/ourPartner_autoplay";
    $title = get_string('autoplay', 'theme_edifi');
    $description = get_string('ourPartnerAutoplay_desc', 'theme_edifi');
    $choices = [1 => $yes , 0 => $no];
    $default = 1;
    $setting = new admin_setting_configselect($name, $title, $description, $default, $choices);
    $temp->add($setting);

    // Our partner autotime.
    $name = "theme_edifi/ourPartner_autotime";
    $title = get_string('ourPartner_autoTime', 'theme_edifi');
    $description = get_string('ourPartnerAutotime_desc', 'theme_edifi');
    $default = 1400;
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Our partner title.
/*    $name = "theme_edifi/ourPartner_title";
    $title = get_string('BlockTitle', 'theme_edifi');
    $description = get_string('ourPartnertitle_desc', 'theme_edifi');
    $default = '';
      $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Our partner description.
    $name = "theme_edifi/ourPartner_desc";
    $title = get_string('BlockDesc', 'theme_edifi');
    $description = get_string('ourPartnerdesc_desc', 'theme_edifi');
    $default = '';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);*/



    $numberofpartners = get_config('theme_edifi', 'ourPartner_number');
    if (!empty($numberofpartners)) {
        $numPartners = intval($numberofpartners);
        for ($key = 1; $key <= $numPartners; $key++) {

            $name = 'theme_edifi/partner' . $key . 'info';
            $heading = get_string('partner', 'theme_edifi')." ".$key;
            $information = '';// get_string('partnerinfo_desc', 'theme_edifi', array('key' => $key));
            $setting = new admin_setting_heading($name, $heading, $information);
            $temp->add($setting);

            $name = "theme_edifi/partner".$key."title";
            $title = get_string('partnertitle', 'theme_edifi');
            $description = get_string('partnertitle_desc', 'theme_edifi');
            $default = get_string('partner', 'theme_edifi') . $key;
            $setting = new admin_setting_configtext($name, $title, $description, $default);

            $temp->add($setting);

            $name = 'theme_edifi/partner'. $key . 'img';
            $title = get_string('partnerimg', 'theme_edifi');
            $description = get_string('partnerimg_desc', 'theme_edifi');
            $default = 'partner'. $key . 'img';
            $setting = new admin_setting_configstoredfile($name , $title, $description, $default);
            $setting->set_updatedcallback('theme_reset_all_caches');
            $temp->add($setting);

            $name = 'theme_edifi/partner'. $key . 'link';
            $title = get_string('partnerlink', 'theme_edifi');
            $description = get_string('partnerlink_desc', 'theme_edifi');
            $default = 'http://www.example.com';
            $setting = new admin_setting_configtext($name , $title, $description, $default);
            $setting->set_updatedcallback('theme_reset_all_caches');
            $temp->add($setting);
        }
    }



    $settings->add($temp);

    // Footer Blocks
    $temp = new admin_settingpage('theme_edifi_footer', get_string('footerheading', 'theme_edifi'));

    /* Footer Block1 */
    $name = 'theme_edifi_footerblock1heading';
    $heading = get_string('footerblock', 'theme_edifi').' 1 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_edifi/footerbstatus1';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_edifi/footerbtitle1';
    $title = get_string('title', 'theme_edifi');
    $description = get_string('footerbtitledesc', 'theme_edifi');
    $default = 'lang:footerbtitle1default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_edifi/footnote';
    $title = get_string('footerDesc', 'theme_edifi');
    $description = get_string('footerdescription_desc', 'theme_edifi', ['blockno' => '1']);
    $default = get_string('footnotedefault', 'theme_edifi');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block1 */

    /* Footer Block2*/
    $name = 'theme_edifi_footerblock2heading';
    $heading = get_string('footerblock', 'theme_edifi').' 2 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    $name = 'theme_edifi/footerbstatus2';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_edifi/footerbtitle2';
    $title = get_string('title', 'theme_edifi');
    $description = get_string('footerbtitledesc', 'theme_edifi');
    $default = 'lang:footerbtitle2default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    $name = 'theme_edifi/footerdesc2';
    $title = get_string('footerDesc', 'theme_edifi');
    $description = get_string('footerdescription_desc', 'theme_edifi', ['blockno' => '2']);
    $default = 'lang:footerblink2default';
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);   // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block2 */

    /* Footer Block1 */
    $name = 'theme_edifi_footerblockcenterheading';
    $heading = get_string('footerblockcenter', 'theme_edifi');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Footer background file.
    $name = 'theme_edifi/footerlogo';
    $title = get_string('footerlogo', 'theme_edifi');
    $description = get_string('footlogo_desc', 'theme_edifi');
    $setting = new admin_setting_configstoredfile($name, $title, $description, 'footerlogo');
    $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);


    /* Address , Email , Phone No */

    $name = 'theme_edifi/address';
    $title = get_string('address', 'theme_edifi');
    $description = '';
    $default = get_string('defaultaddress', 'theme_edifi');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    $temp->add($setting);


    $name = 'theme_edifi/emailid';
    $title = get_string('emailid', 'theme_edifi');
    $description = '';
    $default = get_string('defaultemailid', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    $name = 'theme_edifi/phoneno';
    $title = get_string('phoneno', 'theme_edifi');
    $description = '';
    $default = get_string('defaultphoneno', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);


    /* Footer Block3 */
    $name = 'theme_edifi_footerblock3heading';
    $heading = get_string('footerblock', 'theme_edifi').' 3 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Footer block 3 status
    $name = 'theme_edifi/footerbstatus3';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Footer block title 3
    $name = 'theme_edifi/footerbtitle3';
    $title = get_string('title', 'theme_edifi');
    $description = get_string('footerbtitledesc', 'theme_edifi');
    $default = 'lang:footerbtitle3default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Footer block 3 link
    $name = 'theme_edifi/footerdesc3';
    $title = get_string('footerDesc', 'theme_edifi');
    $description = get_string('footerdescription_desc', 'theme_edifi', ['blockno' => '3']);
    $default = get_string('footerblink3default', 'theme_edifi');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);  // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);
    /* Footer Block3 */

    /* Footer Block4 */
    $name = 'theme_edifi_footerblock4heading';
    $heading = get_string('footerblock', 'theme_edifi').' 4 ';
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    // Footer block 4 status
    $name = 'theme_edifi/footerbstatus4';
    $title = get_string('activateblock', 'theme_edifi');
    $description = get_string('activateblock_desc', 'theme_edifi');
    $default = 1;
    $setting = new admin_setting_configcheckbox($name, $title, $description, $default);
    $temp->add($setting);

    // Footer block 4 Title.
    $name = 'theme_edifi/footerbtitle4';
    $title = get_string('title', 'theme_edifi');
    $description = get_string('footerbtitledesc', 'theme_edifi');
    $default = 'lang:footerbtitle4default';
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    $name = 'theme_edifi/footerdesc4';
    $title = get_string('footerDesc', 'theme_edifi');
    $description = get_string('footerdescription_desc', 'theme_edifi', ['blockno' => '4']);
    $default = get_string('footerblink1default', 'theme_edifi');
    $setting = new admin_setting_confightmleditor($name, $title, $description, $default);
    $temp->add($setting);

    // Copyright.
    $name = 'theme_edifi_copyrightheading';
    $heading = get_string('copyrightheading', 'theme_edifi');
    $information = '';
    $setting = new admin_setting_heading($name, $heading, $information);
    $temp->add($setting);

    /* Facebook, Pinterest,Twitter, Google+ Settings */
    // Social media icon 1 - name.
    $name = 'theme_edifi/socialicon1';
    $title = get_string('socialicon', 'theme_edifi').' 1 ';
    $description = get_string('socialicondesc', 'theme_edifi');
    $default = get_string('socialicon1default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 1.
    $name = 'theme_edifi/siconurl1';
    $title = get_string('socialicon', 'theme_edifi').' 1 '.get_string('url', 'theme_edifi');
    $description = get_string('siconurldesc', 'theme_edifi');
    $default = get_string('siconurl1default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);


    // Social media icon 2 - name.
    $name = 'theme_edifi/socialicon2';
    $title = get_string('socialicon', 'theme_edifi').' 2 ';
    $description = get_string('socialicondesc', 'theme_edifi');
    $default = get_string('socialicon2default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 2.
    $name = 'theme_edifi/siconurl2';
    $title = get_string('socialicon', 'theme_edifi').' 2 '.get_string('url', 'theme_edifi');
    $description = get_string('siconurldesc', 'theme_edifi');
    $default = get_string('siconurl2default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Social media icon 3 - name.
    $name = 'theme_edifi/socialicon3';
    $title = get_string('socialicon', 'theme_edifi').' 3 ';
    $description = get_string('socialicondesc', 'theme_edifi');
    $default = get_string('socialicon3default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 3.
    $name = 'theme_edifi/siconurl3';
    $title = get_string('socialicon', 'theme_edifi').' 3 '.get_string('url', 'theme_edifi');
    $description = get_string('siconurldesc', 'theme_edifi');
    $default = get_string('siconurl3default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // Social media icon 4 - name.
    $name = 'theme_edifi/socialicon4';
    $title = get_string('socialicon', 'theme_edifi').' 4 ';
    $description = get_string('socialicondesc', 'theme_edifi');
    $default = get_string('socialicon4default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    // $setting->set_updatedcallback('theme_reset_all_caches');
    $temp->add($setting);

    // Social Media Icon Url 4.
    $name = 'theme_edifi/siconurl4';
    $title = get_string('socialicon', 'theme_edifi').' 4 '.get_string('url', 'theme_edifi');
    $description = get_string('siconurldesc', 'theme_edifi');
    $default = get_string('siconurl4default', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

                 // Copyright setting.
    $name = 'theme_edifi/copyright';
    $title = get_string('copyright', 'theme_edifi');
    $description = get_string('copyrightdesc', 'theme_edifi');
    $default = get_string('copyrightdefault', 'theme_edifi');
    $setting = new admin_setting_configtext($name, $title, $description, $default);
    $temp->add($setting);

    // $ADMIN->add('theme_edifi', $temp);

    $settings->add($temp);
    /*  Footer Settings end */

    // $ADMIN->add('theme_edifi', $settings);
}